/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.conczin.mca.MCA;
import net.conczin.mca.client.book.Book;
import net.conczin.mca.client.book.CivilRegistryBook;
import net.conczin.mca.client.book.pages.CenteredTextPage;
import net.conczin.mca.client.book.pages.DynamicListPage;
import net.conczin.mca.client.book.pages.ScribbleTextPage;
import net.conczin.mca.client.book.pages.TitlePage;
import net.conczin.mca.entity.CribWoodType;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.item.BlueprintItem;
import net.conczin.mca.item.BouquetItem;
import net.conczin.mca.item.CivilRegistry;
import net.conczin.mca.item.CombItem;
import net.conczin.mca.item.CribItem;
import net.conczin.mca.item.EngagementRingItem;
import net.conczin.mca.item.ExtendedWrittenBookItem;
import net.conczin.mca.item.FamilyTreeItem;
import net.conczin.mca.item.MatchmakersRingItem;
import net.conczin.mca.item.NeedleAndThreadItem;
import net.conczin.mca.item.PotionOfMetamorphosisItem;
import net.conczin.mca.item.ScytheItem;
import net.conczin.mca.item.SirbenBabyItem;
import net.conczin.mca.item.StaffOfLifeItem;
import net.conczin.mca.item.TooltippedItem;
import net.conczin.mca.item.VillagerEditorItem;
import net.conczin.mca.item.VillagerTrackerItem;
import net.conczin.mca.item.WeddingRingItem;
import net.conczin.mca.item.WhistleItem;
import net.conczin.mca.registry.BlocksMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.Supporters;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public interface ItemsMCA {
    public static final Map<ResourceLocation, Item> ITEMS = new LinkedHashMap<ResourceLocation, Item>();
    public static final Item MALE_VILLAGER_SPAWN_EGG = ItemsMCA.register("male_villager_spawn_egg", (Item)new SpawnEggItem(EntitiesMCA.MALE_VILLAGER, 6200063, 3368636, ItemsMCA.baseProps()));
    public static final Item FEMALE_VILLAGER_SPAWN_EGG = ItemsMCA.register("female_villager_spawn_egg", (Item)new SpawnEggItem(EntitiesMCA.FEMALE_VILLAGER, 15228065, 14890636, ItemsMCA.baseProps()));
    public static final Item MALE_ZOMBIE_VILLAGER_SPAWN_EGG = ItemsMCA.register("male_zombie_villager_spawn_egg", (Item)new SpawnEggItem(EntitiesMCA.MALE_ZOMBIE_VILLAGER, 6208255, 3385020, ItemsMCA.baseProps()));
    public static final Item FEMALE_ZOMBIE_VILLAGER_SPAWN_EGG = ItemsMCA.register("female_zombie_villager_spawn_egg", (Item)new SpawnEggItem(EntitiesMCA.FEMALE_ZOMBIE_VILLAGER, 15248545, 14919308, ItemsMCA.baseProps()));
    public static final Item GRIM_REAPER_SPAWN_EGG = ItemsMCA.register("grim_reaper_spawn_egg", (Item)new SpawnEggItem(EntitiesMCA.GRIM_REAPER, 3151125, 2759732, ItemsMCA.baseProps()));
    public static final Item BABY_BOY = ItemsMCA.register("baby_boy", new BabyItem(Gender.MALE, ItemsMCA.baseProps().stacksTo(1)));
    public static final Item BABY_GIRL = ItemsMCA.register("baby_girl", new BabyItem(Gender.FEMALE, ItemsMCA.baseProps().stacksTo(1)));
    public static final Item SIRBEN_BABY_BOY = ItemsMCA.register("sirben_baby_boy", new SirbenBabyItem(Gender.MALE, ItemsMCA.baseProps().stacksTo(1)));
    public static final Item SIRBEN_BABY_GIRL = ItemsMCA.register("sirben_baby_girl", new SirbenBabyItem(Gender.FEMALE, ItemsMCA.baseProps().stacksTo(1)));
    public static final Item WEDDING_RING = ItemsMCA.register("wedding_ring", new WeddingRingItem(ItemsMCA.unstackableProps()));
    public static final Item WEDDING_RING_RG = ItemsMCA.register("wedding_ring_rg", new WeddingRingItem(ItemsMCA.unstackableProps()));
    public static final Item ENGAGEMENT_RING = ItemsMCA.register("engagement_ring", new EngagementRingItem(ItemsMCA.unstackableProps()));
    public static final Item ENGAGEMENT_RING_RG = ItemsMCA.register("engagement_ring_rg", new EngagementRingItem(ItemsMCA.unstackableProps()));
    public static final Item MATCHMAKERS_RING = ItemsMCA.register("matchmakers_ring", new MatchmakersRingItem(ItemsMCA.baseProps().stacksTo(2)));
    public static final Item VILLAGER_EDITOR = ItemsMCA.register("villager_editor", new VillagerEditorItem(ItemsMCA.baseProps()));
    public static final Item STAFF_OF_LIFE = ItemsMCA.register("staff_of_life", new StaffOfLifeItem(ItemsMCA.baseProps().durability(10).rarity(Rarity.EPIC)));
    public static final Item WHISTLE = ItemsMCA.register("whistle", new WhistleItem(ItemsMCA.baseProps()));
    public static final Item BLUEPRINT = ItemsMCA.register("blueprint", new BlueprintItem(ItemsMCA.baseProps()));
    public static final Item FAMILY_TREE = ItemsMCA.register("family_tree", new FamilyTreeItem(ItemsMCA.baseProps()));
    public static final Item VILLAGER_TRACKER = ItemsMCA.register("villager_tracker", new VillagerTrackerItem(ItemsMCA.baseProps().stacksTo(1)));
    public static final Item SCYTHE = ItemsMCA.register("scythe", (Item)new ScytheItem(ItemsMCA.baseProps().attributes(SwordItem.createAttributes((Tier)Tiers.GOLD, (int)10, (float)-2.4f))));
    public static final Item BOUQUET = ItemsMCA.register("bouquet", new BouquetItem(ItemsMCA.baseProps()));
    public static final Item POTION_OF_FEMININITY = ItemsMCA.register("potion_of_femininity", new PotionOfMetamorphosisItem(ItemsMCA.baseProps().stacksTo(1), Gender.FEMALE));
    public static final Item POTION_OF_MASCULINITY = ItemsMCA.register("potion_of_masculinity", new PotionOfMetamorphosisItem(ItemsMCA.baseProps().stacksTo(1), Gender.MALE));
    public static final Item NEEDLE_AND_THREAD = ItemsMCA.register("needle_and_thread", new NeedleAndThreadItem(ItemsMCA.baseProps().durability(8)));
    public static final Item COMB = ItemsMCA.register("comb", new CombItem(ItemsMCA.baseProps().durability(8)));
    public static final Item BOOK_DEATH = ItemsMCA.register("book_death", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("death").setBackground(MCA.locate("textures/gui/books/death.png")).setTextFormatting(ChatFormatting.WHITE).setTextShadow(true).addPage(new TitlePage("death", ChatFormatting.GRAY)).addSimplePages(3, 0).addPage(new ScribbleTextPage(MCA.locate("textures/gui/scribbles/test.png"), "death", 3)).addSimplePages(9, 4)));
    public static final Item BOOK_ROMANCE = ItemsMCA.register("book_romance", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("romance").setBackground(MCA.locate("textures/gui/books/romance.png")).addPage(new TitlePage("romance")).addSimplePages(10)));
    public static final Item BOOK_FAMILY = ItemsMCA.register("book_family", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("family").setBackground(MCA.locate("textures/gui/books/family.png")).addPage(new TitlePage("family")).addSimplePages(6)));
    public static final Item BOOK_ROSE_GOLD = ItemsMCA.register("book_rose_gold", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("rose_gold").setBackground(MCA.locate("textures/gui/books/rose_gold.png")).addPage(new TitlePage("rose_gold")).addSimplePages(4)));
    public static final Item BOOK_INFECTION = ItemsMCA.register("book_infection", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("infection").setBackground(MCA.locate("textures/gui/books/infection.png")).addPage(new TitlePage("infection")).addSimplePages(6)));
    public static final Item BOOK_BLUEPRINT = ItemsMCA.register("book_blueprint", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("blueprint").setBackground(MCA.locate("textures/gui/books/blueprint.png")).setTextFormatting(ChatFormatting.WHITE).setTextShadow(true).addPage(new TitlePage("blueprint", ChatFormatting.WHITE)).addSimplePages(6)));
    public static final Item BOOK_SUPPORTERS = ItemsMCA.register("book_supporters", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("supporters").setBackground(MCA.locate("textures/gui/books/supporters.png")).addPage(new TitlePage("supporters")).addPage(new DynamicListPage("mca.books.supporters.contributors", page -> Supporters.getSupporterGroup("mca:contributors").stream().map(s -> Component.literal((String)s).withStyle(ChatFormatting.DARK_GREEN)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.wiki", page -> Supporters.getSupporterGroup("mca:wiki").stream().map(s -> Component.literal((String)s).withStyle(ChatFormatting.GOLD)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.patrons", page -> Supporters.getSupporterGroup("mca:patrons").stream().map(s -> Component.literal((String)s).withStyle(ChatFormatting.RED)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.translators", page -> Supporters.getSupporterGroup("mca:translators").stream().map(s -> Component.literal((String)s).withStyle(ChatFormatting.DARK_BLUE)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.old", page -> Supporters.getSupporterGroup("mca:old").stream().map(s -> Component.literal((String)s).withStyle(ChatFormatting.BLACK)).collect(Collectors.toList()))).addPage(new TitlePage("mca.books.supporters.thanks", ""))));
    public static final Item BOOK_CULT_0 = ItemsMCA.register("book_cult_0", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("cult_0").setBackground(MCA.locate("textures/gui/books/cult.png")).setTextFormatting(ChatFormatting.DARK_RED).addPage(new TitlePage("cult_0", ChatFormatting.DARK_RED)).addPage(new CenteredTextPage("cult_0", 0)).addPage(new CenteredTextPage("cult_0", 1)).addPage(new CenteredTextPage("cult_0", 2)).addPage(new CenteredTextPage("cult_0", 3)).addPage(new ScribbleTextPage(MCA.locate("textures/gui/scribbles/goat.png"), (Component)Component.literal((String)"")))));
    public static final Item BOOK_CULT_1 = ItemsMCA.register("book_cult_1", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("cult_1").setBackground(MCA.locate("textures/gui/books/cult.png")).setTextFormatting(ChatFormatting.DARK_RED).addPage(new TitlePage("cult_1", ChatFormatting.DARK_RED)).addPage(new CenteredTextPage("cult_1", 0)).addPage(new CenteredTextPage("cult_1", 1)).addPage(new CenteredTextPage("cult_1", 2)).addPage(new CenteredTextPage("cult_1", 3)).addPage(new ScribbleTextPage(MCA.locate("textures/gui/scribbles/goat.png"), (Component)Component.literal((String)"")))));
    public static final Item BOOK_CULT_2 = ItemsMCA.register("book_cult_2", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("cult_2").setBackground(MCA.locate("textures/gui/books/cult.png")).setTextFormatting(ChatFormatting.DARK_RED).addPage(new TitlePage("cult_2", ChatFormatting.DARK_RED)).addPage(new CenteredTextPage("cult_2", 0)).addPage(new CenteredTextPage("cult_2", 1)).addPage(new CenteredTextPage("cult_2", 2)).addPage(new CenteredTextPage("cult_2", 3)).addPage(new ScribbleTextPage(MCA.locate("textures/gui/scribbles/goat.png"), (Component)Component.literal((String)"")))));
    public static final Item BOOK_CULT_ANCIENT = ItemsMCA.register("book_cult_ancient", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("cult_ancient").setBackground(MCA.locate("textures/gui/books/cult.png")).setTextFormatting(ChatFormatting.DARK_RED).addPage(new TitlePage("cult_ancient", ChatFormatting.DARK_RED)).addPage(new CenteredTextPage((Component)Component.literal((String)"We are the universe. We are everything you think isn't you. You are looking at us now, through your skin and your eyes. And why does the universe touch your skin, and throw light on you? To see you, player. To know you. And to be known. I shall tell you a story.")).setStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"alt"))))));
    public static final Item CIVIL_REGISTRY = ItemsMCA.register("civil_registry", (Item)new CivilRegistry(ItemsMCA.baseProps().stacksTo(1), new CivilRegistryBook("civil_registry", null).setBackground(MCA.locate("textures/gui/books/supporters.png"))));
    public static final Item LETTER = ItemsMCA.register("letter", (Item)new ExtendedWrittenBookItem(ItemsMCA.baseProps().stacksTo(1), new Book("letter", null).setBackground(MCA.locate("textures/gui/books/paper.png"))));
    public static final Item DIVORCE_PAPERS = ItemsMCA.register("divorce_papers", new TooltippedItem(ItemsMCA.baseProps()));
    public static final Item ROSE_GOLD_DUST = ItemsMCA.register("rose_gold_dust", new Item(ItemsMCA.baseProps()));
    public static final Item ROSE_GOLD_INGOT = ItemsMCA.register("rose_gold_ingot", new Item(ItemsMCA.baseProps()));
    public static final Item ROSE_GOLD_BLOCK = ItemsMCA.register("rose_gold_block", (Item)new BlockItem(BlocksMCA.ROSE_GOLD_BLOCK, ItemsMCA.baseProps()));
    public static final Item GRAVELLING_HEADSTONE = ItemsMCA.register("gravelling_headstone", (Item)new BlockItem(BlocksMCA.GRAVELLING_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item UPRIGHT_HEADSTONE = ItemsMCA.register("upright_headstone", (Item)new BlockItem(BlocksMCA.UPRIGHT_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item SLANTED_HEADSTONE = ItemsMCA.register("slanted_headstone", (Item)new BlockItem(BlocksMCA.SLANTED_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item CROSS_HEADSTONE = ItemsMCA.register("cross_headstone", (Item)new BlockItem(BlocksMCA.CROSS_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item WALL_HEADSTONE = ItemsMCA.register("wall_headstone", (Item)new BlockItem(BlocksMCA.WALL_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item COBBLESTONE_UPRIGHT_HEADSTONE = ItemsMCA.register("cobblestone_upright_headstone", (Item)new BlockItem(BlocksMCA.COBBLESTONE_UPRIGHT_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item COBBLESTONE_SLANTED_HEADSTONE = ItemsMCA.register("cobblestone_slanted_headstone", (Item)new BlockItem(BlocksMCA.COBBLESTONE_SLANTED_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item WOODEN_UPRIGHT_HEADSTONE = ItemsMCA.register("wooden_upright_headstone", (Item)new BlockItem(BlocksMCA.WOODEN_UPRIGHT_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item WOODEN_SLANTED_HEADSTONE = ItemsMCA.register("wooden_slanted_headstone", (Item)new BlockItem(BlocksMCA.WOODEN_SLANTED_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item GOLDEN_UPRIGHT_HEADSTONE = ItemsMCA.register("golden_upright_headstone", (Item)new BlockItem(BlocksMCA.GOLDEN_UPRIGHT_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item GOLDEN_SLANTED_HEADSTONE = ItemsMCA.register("golden_slanted_headstone", (Item)new BlockItem(BlocksMCA.GOLDEN_SLANTED_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item DEEPSLATE_UPRIGHT_HEADSTONE = ItemsMCA.register("deepslate_upright_headstone", (Item)new BlockItem(BlocksMCA.DEEPSLATE_UPRIGHT_HEADSTONE, ItemsMCA.baseProps()));
    public static final Item DEEPSLATE_SLANTED_HEADSTONE = ItemsMCA.register("deepslate_slanted_headstone", (Item)new BlockItem(BlocksMCA.DEEPSLATE_SLANTED_HEADSTONE, ItemsMCA.baseProps()));
    public static final List<CribItem> CRIBS = ItemsMCA.registerAllCribTypes();

    public static List<CribItem> registerAllCribTypes() {
        ArrayList<CribItem> cribs = new ArrayList<CribItem>();
        for (CribWoodType wood : CribWoodType.values()) {
            for (DyeColor color : DyeColor.values()) {
                cribs.add((CribItem)ItemsMCA.register(color.getName() + "_" + wood.toString().toLowerCase(Locale.ROOT) + "_crib", new CribItem(ItemsMCA.unstackableProps(), wood, color)));
            }
        }
        return cribs;
    }

    public static Item register(String name, Item item) {
        ITEMS.put(MCA.locate(name), item);
        return item;
    }

    public static Item.Properties baseProps() {
        return new Item.Properties();
    }

    public static Item.Properties unstackableProps() {
        return ItemsMCA.baseProps().stacksTo(1);
    }

    public static void registerItems(MCA.RegisterHelper<Item> helper) {
        ITEMS.forEach(helper::register);
    }
}

