/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.conczin.mca.MCA;
import net.conczin.mca.mixin.MixinVillagerProfession;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface ProfessionsMCA {
    public static final Map<ResourceLocation, VillagerProfession> PROFESSIONS = new HashMap<ResourceLocation, VillagerProfession>();
    public static final Set<VillagerProfession> CAN_NOT_TRADE = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> IS_IMPORTANT = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> NEEDS_NO_HOME = new HashSet<VillagerProfession>();
    public static final VillagerProfession OUTLAW = ProfessionsMCA.register("outlaw", false, true, true, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_FARMER);
    public static final VillagerProfession GUARD = ProfessionsMCA.register("guard", false, true, false, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_ARMORER);
    public static final VillagerProfession ARCHER = ProfessionsMCA.register("archer", false, true, false, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_FLETCHER);
    public static final VillagerProfession ADVENTURER = ProfessionsMCA.register("adventurer", true, true, true, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_FLETCHER);
    public static final VillagerProfession MERCENARY = ProfessionsMCA.register("mercenary", false, true, true, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_FLETCHER);
    public static final VillagerProfession CULTIST = ProfessionsMCA.register("cultist", true, true, true, PoiType.NONE, VillagerProfession.ALL_ACQUIRABLE_JOBS, SoundEvents.VILLAGER_WORK_FLETCHER);

    public static VillagerProfession register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, Predicate<Holder<PoiType>> heldWorkstation, Predicate<Holder<PoiType>> acquirableWorkstation, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, heldWorkstation, acquirableWorkstation, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), workSound);
    }

    public static VillagerProfession register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, ResourceKey<PoiType> heldWorkstation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, entry -> entry.is(heldWorkstation), entry -> entry.is(heldWorkstation), gatherableItems, secondaryJobSites, workSound);
    }

    public static VillagerProfession register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, Predicate<Holder<PoiType>> heldWorkstation, Predicate<Holder<PoiType>> acquirableWorkstation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        ResourceLocation id = MCA.locate(name);
        VillagerProfession result = MixinVillagerProfession.init(id.toString().replace(':', '.'), heldWorkstation, acquirableWorkstation, gatherableItems, secondaryJobSites, workSound);
        if (!canTradeWith) {
            CAN_NOT_TRADE.add(result);
        }
        if (important) {
            IS_IMPORTANT.add(result);
        }
        if (needsNoHome) {
            NEEDS_NO_HOME.add(result);
        }
        PROFESSIONS.put(id, result);
        return result;
    }

    public static String getFavoredBuilding(VillagerProfession profession) {
        if (VillagerProfession.CARTOGRAPHER == profession || VillagerProfession.LIBRARIAN == profession || VillagerProfession.CLERIC == profession) {
            return "library";
        }
        if (GUARD == profession || ARCHER == profession) {
            return "inn";
        }
        return null;
    }

    public static void registerProfessions(MCA.RegisterHelper<VillagerProfession> helper) {
        PROFESSIONS.forEach(helper::register);
        CAN_NOT_TRADE.add(VillagerProfession.NONE);
        CAN_NOT_TRADE.add(VillagerProfession.NITWIT);
    }
}

