/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.conczin.mca.MCA;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Resources;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.resources.data.tasks.TaskRegistry;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class Tasks
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("tasks");
    private static Tasks INSTANCE;
    public final Map<Rank, List<Task>> tasks = new HashMap<Rank, List<Task>>();

    public Tasks() {
        super(Resources.GSON, ID.getPath());
        INSTANCE = this;
    }

    public static Tasks getInstance() {
        return INSTANCE;
    }

    public static Set<String> getCompletedIds(Village village, ServerPlayer player) {
        return Tasks.getInstance().tasks.values().stream().flatMap(Collection::stream).filter(t -> t.isCompleted(village, player)).map(Task::getId).collect(Collectors.toSet());
    }

    public static Rank getRank(Village village, ServerPlayer player) {
        Rank[] ranks = Rank.values();
        for (int i = ranks.length - 1; i >= 0; --i) {
            if (!Tasks.getInstance().tasks.get((Object)ranks[i]).stream().allMatch(t -> !t.isRequired() || t.isCompleted(village, player))) continue;
            return ranks[i];
        }
        return Rank.OUTLAW;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.tasks.clear();
        for (Rank r : Rank.values()) {
            this.tasks.put(r, new LinkedList());
        }
        data.forEach((id, file) -> {
            Rank rank = Rank.fromName(id.getPath().split("\\.")[0]);
            file.getAsJsonArray().forEach(entry -> {
                Task task = TaskRegistry.fromJson(entry.getAsJsonObject());
                this.tasks.get((Object)rank).add(task);
            });
        });
    }
}

