/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.MCA;
import net.conczin.mca.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

public final class BuildingType {
    public static final StreamCodec<FriendlyByteBuf, BuildingType> STREAM_CODEC = StreamCodec.of((buf, buildingType) -> {
        buf.writeUtf(buildingType.name);
        buf.writeVarInt(buildingType.margin);
        buf.writeUtf(buildingType.color);
        buf.writeVarInt(buildingType.priority);
        buf.writeBoolean(buildingType.visible);
        buf.writeBoolean(buildingType.noBeds);
        buf.writeBoolean(buildingType.icon);
        buf.writeVarInt(buildingType.iconU);
        buf.writeVarInt(buildingType.iconV);
        buf.writeBoolean(buildingType.grouped);
        buf.writeVarInt(buildingType.mergeRange);
        buf.writeVarInt(buildingType.blocks.size());
        buildingType.blocks.forEach((key, value) -> {
            buf.writeUtf(key);
            buf.writeVarInt(value.intValue());
        });
    }, buf -> {
        String name = buf.readUtf();
        int margin = buf.readVarInt();
        String color = buf.readUtf();
        int priority = buf.readVarInt();
        boolean visible = buf.readBoolean();
        boolean noBeds = buf.readBoolean();
        boolean icon = buf.readBoolean();
        int iconU = buf.readVarInt();
        int iconV = buf.readVarInt();
        boolean grouped = buf.readBoolean();
        int mergeRange = buf.readVarInt();
        int blocksSize = buf.readVarInt();
        HashMap<String, Integer> blocks = new HashMap<String, Integer>(blocksSize);
        for (int i = 0; i < blocksSize; ++i) {
            blocks.put(buf.readUtf(), buf.readVarInt());
        }
        return new BuildingType(name, margin, color, priority, visible, noBeds, icon, iconU, iconV, grouped, mergeRange, blocks);
    });
    private final String name;
    private final int margin;
    private final String color;
    private final int priority;
    private final boolean visible;
    private final boolean noBeds;
    private final Map<String, Integer> blocks;
    private final boolean icon;
    private final int iconU;
    private final int iconV;
    private final boolean grouped;
    private final int mergeRange;
    private transient Map<ResourceLocation, ResourceLocation> blockToGroup;
    private transient Map<ResourceLocation, Integer> groups;

    private BuildingType(String name, int margin, String color, int priority, boolean visible, boolean noBeds, boolean icon, int iconU, int iconV, boolean grouped, int mergeRange, Map<String, Integer> blocks) {
        this.name = name;
        this.margin = margin;
        this.color = color;
        this.priority = priority;
        this.visible = visible;
        this.noBeds = noBeds;
        this.icon = icon;
        this.iconU = iconU;
        this.iconV = iconV;
        this.grouped = grouped;
        this.mergeRange = mergeRange;
        this.blocks = blocks;
    }

    public BuildingType() {
        this.name = "?";
        this.margin = 0;
        this.color = "ffffffff";
        this.priority = 0;
        this.visible = true;
        this.noBeds = false;
        this.blocks = Map.of("#minecraft:beds", 1000000000);
        this.blockToGroup = null;
        this.icon = false;
        this.iconU = 0;
        this.iconV = 0;
        this.grouped = false;
        this.mergeRange = 32;
    }

    public BuildingType(String name, JsonObject value) {
        JsonObject blocks;
        this.name = name;
        this.margin = GsonHelper.getAsInt((JsonObject)value, (String)"margin", (int)0);
        this.color = GsonHelper.getAsString((JsonObject)value, (String)"color", (String)"ffffffff");
        this.priority = GsonHelper.getAsInt((JsonObject)value, (String)"priority", (int)0);
        this.visible = GsonHelper.getAsBoolean((JsonObject)value, (String)"visible", (boolean)true);
        this.noBeds = GsonHelper.getAsBoolean((JsonObject)value, (String)"noBeds", (boolean)false);
        this.icon = GsonHelper.getAsBoolean((JsonObject)value, (String)"icon", (boolean)false);
        this.iconU = GsonHelper.getAsInt((JsonObject)value, (String)"iconU", (int)0);
        this.iconV = GsonHelper.getAsInt((JsonObject)value, (String)"iconV", (int)0);
        this.grouped = GsonHelper.getAsBoolean((JsonObject)value, (String)"grouped", (boolean)false);
        this.mergeRange = GsonHelper.getAsInt((JsonObject)value, (String)"mergeRange", (int)0);
        this.blocks = new HashMap<String, Integer>();
        if (GsonHelper.isObjectNode((JsonObject)value, (String)"blocks")) {
            blocks = GsonHelper.getAsJsonObject((JsonObject)value, (String)"blocks");
            for (Map.Entry entry : blocks.entrySet()) {
                this.blocks.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
        this.groups = new HashMap<ResourceLocation, Integer>();
        if (GsonHelper.isObjectNode((JsonObject)value, (String)"groups")) {
            blocks = GsonHelper.getAsJsonObject((JsonObject)value, (String)"groups");
            for (Map.Entry entry : blocks.entrySet()) {
                this.groups.put(ResourceLocation.parse((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
    }

    public String name() {
        return this.name;
    }

    public String color() {
        return this.color;
    }

    public int priority() {
        return this.priority;
    }

    public boolean visible() {
        return this.visible;
    }

    public int getColor() {
        return (int)Long.parseLong(this.color, 16);
    }

    public Map<ResourceLocation, ResourceLocation> getBlockToGroup() {
        if (this.blockToGroup == null) {
            this.blockToGroup = new HashMap<ResourceLocation, ResourceLocation>();
            this.groups = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry<String, Integer> requirement : this.blocks.entrySet()) {
                ResourceLocation identifier;
                if (requirement.getKey().startsWith("#")) {
                    identifier = ResourceLocation.parse((String)requirement.getKey().substring(1));
                    TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
                    if (RegistryHelper.isTagEmpty(tag)) {
                        MCA.LOGGER.error("Unknown building type tag {}", (Object)identifier);
                    } else {
                        Optional<HolderSet<HolderSet>> entries = RegistryHelper.getEntries(tag);
                        entries.ifPresent(registryEntries -> {
                            for (Block b : registryEntries.stream().map(Holder::value).toList()) {
                                this.blockToGroup.putIfAbsent(BuiltInRegistries.BLOCK.getKey((Object)b), identifier);
                            }
                        });
                    }
                } else {
                    identifier = ResourceLocation.parse((String)requirement.getKey());
                    this.blockToGroup.put(identifier, identifier);
                }
                this.groups.put(identifier, requirement.getValue());
            }
        }
        return this.blockToGroup;
    }

    public Map<ResourceLocation, Integer> getGroups() {
        this.getBlockToGroup();
        return this.groups;
    }

    public Map<ResourceLocation, List<BlockPos>> getGroups(Map<ResourceLocation, List<BlockPos>> blocks) {
        HashMap<ResourceLocation, List<BlockPos>> available = new HashMap<ResourceLocation, List<BlockPos>>();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : blocks.entrySet()) {
            Optional.ofNullable(this.getBlockToGroup().get(entry.getKey())).ifPresent(v -> available.computeIfAbsent((ResourceLocation)v, k -> new LinkedList()).addAll((Collection)entry.getValue()));
        }
        return available;
    }

    public boolean isIcon() {
        return this.icon;
    }

    public int iconU() {
        return this.iconU * 20;
    }

    public int iconV() {
        return this.iconV * 60;
    }

    public boolean grouped() {
        return this.grouped;
    }

    public int mergeRange() {
        return this.mergeRange;
    }

    public boolean noBeds() {
        return this.noBeds;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getMinBlocks() {
        return this.blocks.values().stream().mapToInt(v -> v).sum();
    }
}

