/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.skin;

import com.google.gson.JsonObject;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public abstract class SkinListEntry {
    protected final String identifier;
    protected final Gender gender;
    protected final float chance;

    public SkinListEntry(String identifier) {
        this(identifier, Gender.NEUTRAL, 1.0f);
    }

    public SkinListEntry(String identifier, Gender gender, float chance) {
        this.identifier = identifier;
        this.gender = gender;
        this.chance = chance;
    }

    public SkinListEntry(String identifier, JsonObject object) {
        this.identifier = identifier;
        this.gender = Gender.byId(GsonHelper.getAsInt((JsonObject)object, (String)"gender", (int)0));
        this.chance = GsonHelper.getAsFloat((JsonObject)object, (String)"chance", (float)1.0f);
    }

    public String getPath() {
        return ResourceLocation.parse((String)this.identifier).getPath();
    }

    public JsonObject toJson() {
        JsonObject j = new JsonObject();
        j.addProperty("gender", (Number)(this.gender == null ? Gender.NEUTRAL.getId() : this.gender.getId()));
        j.addProperty("chance", (Number)Float.valueOf(this.chance));
        return j;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Gender getGender() {
        return this.gender;
    }

    public float getChance() {
        if (this.chance <= 0.0f) {
            return 1.0f;
        }
        return this.chance;
    }
}

