/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.tasks;

import com.google.gson.JsonObject;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class ReputationTask
extends Task {
    public static final String TYPE = "reputation";
    private final int reputation;

    public ReputationTask(int reputation) {
        super("reputation_" + reputation);
        this.reputation = reputation;
    }

    public ReputationTask(JsonObject json) {
        this(GsonHelper.getAsInt((JsonObject)json, (String)TYPE));
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE);
        json.addProperty(TYPE, (Number)this.reputation);
        return json;
    }

    @Override
    public boolean isCompleted(Village village, ServerPlayer player) {
        return village.getReputation((Player)player) >= this.reputation;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public MutableComponent getTranslatable() {
        return Component.translatable((String)"task.reputation", (Object[])new Object[]{this.reputation});
    }
}

