/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.tasks;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.conczin.mca.resources.data.tasks.AdvancementTask;
import net.conczin.mca.resources.data.tasks.BlockingTask;
import net.conczin.mca.resources.data.tasks.BuildingTask;
import net.conczin.mca.resources.data.tasks.PopulationTask;
import net.conczin.mca.resources.data.tasks.ReputationTask;
import net.conczin.mca.resources.data.tasks.Task;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.GsonHelper;

public class TaskRegistry {
    public static Map<String, Function<JsonObject, Task>> DECODER = new HashMap<String, Function<JsonObject, Task>>();
    public static final StreamCodec<ByteBuf, Task> CODEC = StreamCodec.of((out, value) -> ByteBufCodecs.STRING_UTF8.encode(out, (Object)value.serialize().toString()), in -> {
        String json = (String)ByteBufCodecs.STRING_UTF8.decode(in);
        return TaskRegistry.fromJson(GsonHelper.parse((String)json));
    });

    static void register(String id, Function<JsonObject, Task> decoder) {
        DECODER.put(id, decoder);
    }

    public static Task fromJson(JsonObject json) {
        String id = GsonHelper.getAsString((JsonObject)json, (String)"type");
        Function<JsonObject, Task> decoder = DECODER.get(id);
        if (decoder == null) {
            throw new IllegalArgumentException("Unknown task type: " + id);
        }
        return decoder.apply(json);
    }

    static {
        TaskRegistry.register("advancement", AdvancementTask::new);
        TaskRegistry.register("blocking", BlockingTask::new);
        TaskRegistry.register("building", BuildingTask::new);
        TaskRegistry.register("population", PopulationTask::new);
        TaskRegistry.register("reputation", ReputationTask::new);
    }
}

