/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.GrimReaperEntity;
import net.conczin.mca.registry.BlocksMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.SoundsMCA;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ReaperSpawner {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private final Object lock = new Object();
    private final Map<Long, ActiveSummon> activeSummons = new ConcurrentHashMap<Long, ActiveSummon>();
    private final VillageManager manager;

    public ReaperSpawner(VillageManager manager) {
        this.manager = manager;
    }

    public ReaperSpawner(VillageManager manager, CompoundTag nbt) {
        this.manager = manager;
        NbtHelper.toList((Tag)nbt.getList("summons", 10), n -> new ActiveSummon((CompoundTag)n)).forEach(summon -> this.activeSummons.put(summon.position.spawnPosition.asLong(), (ActiveSummon)summon));
    }

    private void warn(Level world, BlockPos pos, String phrase) {
        world.players().stream().min(Comparator.comparingInt(a -> a.blockPosition().distManhattan((Vec3i)pos))).ifPresent(p -> p.displayClientMessage((Component)Component.translatable((String)phrase).withStyle(ChatFormatting.RED), true));
    }

    public void trySpawnReaper(ServerLevel world, BlockPos pos) {
        if (!Config.getInstance().allowGrimReaper) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!WorldUtils.isAreaLoaded(world, chunkPos, 1)) {
            return;
        }
        if (world.getBlockState(pos).getBlock() != Blocks.EMERALD_BLOCK) {
            return;
        }
        MCA.LOGGER.info("Attempting to spawn reaper at {} in {}", (Object)pos, (Object)world.dimension().location());
        if (!this.isNightTime((Level)world)) {
            this.warn((Level)world, pos, "reaper.day");
            return;
        }
        Set<BlockPos> totems = this.getTotemsFires((Level)world, pos);
        MCA.LOGGER.info("It is night time, found {} totems", (Object)totems.size());
        if (totems.size() < 3) {
            this.warn((Level)world, pos, "reaper.totems");
            return;
        }
        this.start(new SummonPosition(pos.above(), totems));
        EntityType.LIGHTNING_BOLT.spawn(world, pos, MobSpawnType.TRIGGERED);
        world.setBlock(pos, Blocks.SOUL_SOIL.defaultBlockState(), 3);
        world.setBlock(pos.above(), BlocksMCA.INFERNAL_FLAME.defaultBlockState(), 3);
        totems.forEach(totem -> world.setBlock(totem, BlocksMCA.INFERNAL_FLAME.defaultBlockState(), 18));
    }

    private void start(SummonPosition pos) {
        this.activeSummons.computeIfAbsent(pos.spawnPosition.asLong(), ActiveSummon::new).start(pos);
        this.manager.setDirty();
    }

    public void tick(ServerLevel world) {
        boolean empty = this.activeSummons.isEmpty();
        this.activeSummons.values().removeIf(summon -> {
            try {
                return summon.tick(world);
            }
            catch (Exception e) {
                MCA.LOGGER.error("Exception ticking summon", (Throwable)e);
                return true;
            }
        });
        if (!empty) {
            this.manager.setDirty();
        }
    }

    private boolean isNightTime(Level world) {
        long time = world.getDayTime() % 24000L;
        MCA.LOGGER.info("Current time is {}", (Object)time);
        return time >= 13000L && time <= 23000L;
    }

    private Set<BlockPos> getTotemsFires(Level world, BlockPos pos) {
        int groundY = pos.getY() - 1;
        int leftSkyHeight = world.getMaxBuildHeight() - groundY;
        int minPillarHeight = Math.min(Config.getInstance().minPillarHeight, leftSkyHeight);
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        return Stream.of(HORIZONTALS).map(d -> target.set((Vec3i)pos).setY(groundY).move(d, 3)).filter(pillarPos -> {
            for (int height = 1; height <= leftSkyHeight; ++height) {
                pillarPos.setY(groundY + height);
                if (world.getBlockState((BlockPos)pillarPos).is(Blocks.OBSIDIAN)) continue;
                if (world.getBlockState((BlockPos)pillarPos).is(BlockTags.FIRE)) {
                    return height - 1 >= minPillarHeight;
                }
                return false;
            }
            return false;
        }).map(BlockPos::immutable).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag writeNbt() {
        Object object = this.lock;
        synchronized (object) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("summons", (Tag)NbtHelper.fromList(this.activeSummons.values(), ActiveSummon::write));
            return nbt;
        }
    }

    static class SummonPosition {
        public final BlockPos spawnPosition;
        public final BlockPos fire;
        public final Set<BlockPos> totems;

        public SummonPosition(CompoundTag tag) {
            this.spawnPosition = NbtUtils.readBlockPos((CompoundTag)tag, (String)"spawnPosition").orElse(BlockPos.ZERO);
            this.fire = NbtUtils.readBlockPos((CompoundTag)tag, (String)"fire").orElse(BlockPos.ZERO);
            this.totems = new HashSet<BlockPos>(NbtHelper.toList((Tag)tag.getCompound("totems"), v -> SummonPosition.readBlockPos(((IntArrayTag)v).getAsIntArray())));
        }

        public SummonPosition(BlockPos fire, Set<BlockPos> totems) {
            this.fire = fire;
            this.spawnPosition = fire.above(10);
            this.totems = totems;
        }

        public static BlockPos readBlockPos(int[] aint) {
            return aint.length == 3 ? new BlockPos(aint[0], aint[1], aint[2]) : BlockPos.ZERO;
        }

        public boolean isCancelled(Level world) {
            return !this.check(this.fire, world);
        }

        private boolean check(BlockPos pos, Level world) {
            return world.getBlockState(pos).is(BlocksMCA.INFERNAL_FLAME);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.put("fire", NbtUtils.writeBlockPos((BlockPos)this.fire));
            tag.put("totems", (Tag)NbtHelper.fromList(this.totems, NbtUtils::writeBlockPos));
            tag.put("spawnPosition", NbtUtils.writeBlockPos((BlockPos)this.spawnPosition));
            return tag;
        }
    }

    static class ActiveSummon {
        private int ticks;
        private SummonPosition position;

        ActiveSummon(long l) {
        }

        ActiveSummon(CompoundTag nbt) {
            this.ticks = nbt.getInt("ticks");
            this.position = new SummonPosition(nbt.getCompound("position"));
        }

        public void start(SummonPosition pos) {
            if (this.ticks <= 0) {
                this.position = pos;
                this.ticks = 100;
            }
        }

        public boolean tick(ServerLevel world) {
            if (this.ticks <= 0 || this.position == null) {
                return true;
            }
            if (this.position.isCancelled((Level)world)) {
                this.position.totems.forEach(totem -> {
                    if (this.position.check((BlockPos)totem, (Level)world)) {
                        world.setBlockAndUpdate(totem, Blocks.FIRE.defaultBlockState());
                    }
                });
                this.position = null;
                this.ticks = 0;
                return true;
            }
            if (--this.ticks % 20 == 0) {
                EntityType.LIGHTNING_BOLT.spawn(world, this.position.spawnPosition, MobSpawnType.TRIGGERED);
            }
            if (this.ticks == 0) {
                GrimReaperEntity reaper = (GrimReaperEntity)EntitiesMCA.GRIM_REAPER.spawn(world, this.position.spawnPosition, MobSpawnType.TRIGGERED);
                if (reaper != null) {
                    reaper.playSound(SoundsMCA.REAPER_SUMMON, 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("ticks", this.ticks);
            nbt.put("position", (Tag)this.position.toNbt());
            return nbt;
        }
    }
}

