/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.resources.data.BuildingType;
import net.conczin.mca.util.NbtHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class Building {
    public static final long SCAN_COOLDOWN = 4800L;
    private static final Direction[] directions = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final Map<ResourceLocation, List<BlockPos>> blocks = new HashMap<ResourceLocation, List<BlockPos>>();
    private String type = "building";
    private boolean isTypeForced = false;
    private int size;
    private int pos0X;
    private int pos0Y;
    private int pos0Z;
    private int pos1X;
    private int pos1Y;
    private int pos1Z;
    private int posX;
    private int posY;
    private int posZ;
    private int id;
    private boolean strictScan;
    private long lastScan;

    public Building() {
    }

    public Building(BlockPos pos) {
        this(pos, false);
    }

    public Building(BlockPos pos, boolean strictScan) {
        this();
        this.pos0X = pos.getX();
        this.pos0Y = pos.getY();
        this.pos0Z = pos.getZ();
        this.pos1X = this.pos0X;
        this.pos1Y = this.pos0Y;
        this.pos1Z = this.pos0Z;
        this.posX = this.pos0X;
        this.posY = this.pos0Y;
        this.posZ = this.pos0Z;
        this.strictScan = strictScan;
    }

    public Building(CompoundTag v) {
        this.id = v.getInt("id");
        this.size = v.getInt("size");
        this.pos0X = v.getInt("pos0X");
        this.pos0Y = v.getInt("pos0Y");
        this.pos0Z = v.getInt("pos0Z");
        this.pos1X = v.getInt("pos1X");
        this.pos1Y = v.getInt("pos1Y");
        this.pos1Z = v.getInt("pos1Z");
        if (v.contains("posX")) {
            this.posX = v.getInt("posX");
            this.posY = v.getInt("posY");
            this.posZ = v.getInt("posZ");
        } else {
            BlockPos center = this.getCenter();
            this.posX = center.getX();
            this.posY = center.getY();
            this.posZ = center.getZ();
        }
        this.isTypeForced = v.getBoolean("isTypeForced");
        this.type = v.getString("type");
        this.strictScan = v.getBoolean("strictScan");
        this.blocks.putAll(NbtHelper.toMap(v.getCompound("blocks2"), ResourceLocation::parse, l -> NbtHelper.toList(l, e -> {
            CompoundTag c = (CompoundTag)e;
            return new BlockPos(c.getInt("x"), c.getInt("y"), c.getInt("z"));
        })));
    }

    public CompoundTag save() {
        CompoundTag v = new CompoundTag();
        v.putInt("id", this.id);
        v.putInt("size", this.size);
        v.putInt("pos0X", this.pos0X);
        v.putInt("pos0Y", this.pos0Y);
        v.putInt("pos0Z", this.pos0Z);
        v.putInt("pos1X", this.pos1X);
        v.putInt("pos1Y", this.pos1Y);
        v.putInt("pos1Z", this.pos1Z);
        v.putInt("posX", this.posX);
        v.putInt("posY", this.posY);
        v.putInt("posZ", this.posZ);
        v.putBoolean("isTypeForced", this.isTypeForced);
        v.putString("type", this.type);
        v.putBoolean("strictScan", this.strictScan);
        CompoundTag b = new CompoundTag();
        NbtHelper.fromMap(b, this.blocks, ResourceLocation::toString, e -> NbtHelper.fromList(e, p -> {
            CompoundTag entry = new CompoundTag();
            entry.putInt("x", p.getX());
            entry.putInt("y", p.getY());
            entry.putInt("z", p.getZ());
            return entry;
        }));
        v.put("blocks2", (Tag)b);
        return v;
    }

    public BlockPos getPos0() {
        int margin = this.getBuildingType().getMargin();
        return new BlockPos(this.pos0X, this.pos0Y, this.pos0Z).subtract(new Vec3i(margin, margin, margin));
    }

    public BlockPos getPos1() {
        int margin = this.getBuildingType().getMargin();
        return new BlockPos(this.pos1X, this.pos1Y, this.pos1Z).offset(new Vec3i(margin, margin, margin));
    }

    public BlockPos getCenter() {
        return new BlockPos((this.pos0X + this.pos1X) / 2, (this.pos0Y + this.pos1Y) / 2, (this.pos0Z + this.pos1Z) / 2);
    }

    public BlockPos getSourceBlock() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public void validateBlocks(Level world) {
        this.setLastScan(world.getGameTime());
        for (Map.Entry<ResourceLocation, List<BlockPos>> positions : this.blocks.entrySet()) {
            List<BlockPos> mask = positions.getValue().stream().filter(p -> !BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(p).getBlock()).equals(positions.getKey())).toList();
            positions.getValue().removeAll(mask);
        }
    }

    public Stream<BlockPos> getBlockPosStream() {
        return this.blocks.values().stream().flatMap(Collection::stream);
    }

    public void addPOI(Level world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        this.removeBlock(block, pos);
        this.addBlock(block, pos);
        this.validateBlocks(world);
        int n = (int)this.getBlockPosStream().count();
        if (n > 0) {
            BlockPos center = this.getBlockPosStream().reduce(BlockPos.ZERO, BlockPos::offset);
            this.pos0X = center.getX() / n;
            this.pos0Y = center.getY() / n;
            this.pos0Z = center.getZ() / n;
            this.pos1X = this.pos0X;
            this.pos1Y = this.pos0Y;
            this.pos1Z = this.pos0Z;
        }
    }

    public validationResult validateBuilding(Level world, Set<BlockPos> blocked) {
        BlockState block;
        if (this.getBuildingType().grouped()) {
            this.validateBlocks(world);
            return this.getBlockPosStream().findAny().isEmpty() ? validationResult.TOO_SMALL : validationResult.SUCCESS;
        }
        this.blocks.clear();
        this.size = 0;
        this.setLastScan(world.getGameTime());
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockPos center = this.getSourceBlock();
        queue.add(center);
        done.add(center);
        int minSize = Config.getInstance().minBuildingSize;
        int maxSize = Config.getInstance().maxBuildingSize;
        int maxRadius = Config.getInstance().maxBuildingRadius;
        int interiorSize = 0;
        boolean hasDoor = false;
        HashMap<BlockPos, Boolean> roofCache = new HashMap<BlockPos, Boolean>();
        for (int scanSize = 0; !queue.isEmpty() && scanSize < maxSize; ++scanSize) {
            BlockPos p = (BlockPos)queue.removeLast();
            if (blocked.contains(p) && scanSize > 0) {
                return validationResult.OVERLAP;
            }
            if (p.distManhattan((Vec3i)center) < maxRadius) {
                for (Direction d : directions) {
                    BlockPos n = p.relative(d);
                    if (done.contains(n)) continue;
                    BlockState state = world.getBlockState(n);
                    done.add(n);
                    if (state.isAir()) {
                        if (!roofCache.containsKey(n)) {
                            BlockPos n2 = n;
                            int maxScanHeight = 16;
                            for (int i = 0; i < maxScanHeight; ++i) {
                                roofCache.put(n2, false);
                                n2 = n2.above();
                                block = world.getBlockState(n2);
                                if (block.isAir() && !roofCache.containsKey(n2)) continue;
                                if (roofCache.containsKey(n2) && !((Boolean)roofCache.get(n2)).booleanValue() || block.is(BlockTags.LEAVES)) break;
                                for (int i2 = i; i2 >= 0; --i2) {
                                    n2 = n2.below();
                                    roofCache.put(n2, true);
                                }
                                break;
                            }
                        }
                        if (!((Boolean)roofCache.get(n)).booleanValue()) continue;
                        ++interiorSize;
                        queue.add(n);
                        continue;
                    }
                    if (!(state.getBlock() instanceof DoorBlock)) continue;
                    if (!this.strictScan) {
                        queue.add(n);
                    }
                    hasDoor = true;
                }
                continue;
            }
            return validationResult.SIZE_LIMIT;
        }
        if (!queue.isEmpty()) {
            return validationResult.BLOCK_LIMIT;
        }
        if (done.size() <= minSize) {
            return validationResult.TOO_SMALL;
        }
        if (!hasDoor) {
            return validationResult.NO_DOOR;
        }
        HashSet<ResourceLocation> blockTypes = new HashSet<ResourceLocation>();
        for (BuildingType bt : BuildingTypes.getInstance()) {
            blockTypes.addAll(bt.getBlockToGroup().keySet());
        }
        int sx = center.getX();
        int sy = center.getY();
        int sz = center.getZ();
        int ex = sx;
        int ey = sy;
        int ez = sz;
        for (BlockPos p : done) {
            sx = Math.min(sx, p.getX());
            sy = Math.min(sy, p.getY());
            sz = Math.min(sz, p.getZ());
            ex = Math.max(ex, p.getX());
            ey = Math.max(ey, p.getY());
            ez = Math.max(ez, p.getZ());
            BlockState blockState = world.getBlockState(p);
            block = blockState.getBlock();
            if (!blockTypes.contains(BuiltInRegistries.BLOCK.getKey((Object)block))) continue;
            if (block instanceof BedBlock) {
                if (blockState.getValue((Property)BedBlock.PART) != BedPart.HEAD) continue;
                this.addBlock((Block)block, p);
                continue;
            }
            this.addBlock((Block)block, p);
        }
        this.pos0X = sx;
        this.pos0Y = sy;
        this.pos0Z = sz;
        this.pos1X = ex;
        this.pos1Y = ey;
        this.pos1Z = ez;
        this.size = interiorSize;
        return this.isTypeForced() || this.determineType() ? validationResult.SUCCESS : validationResult.INVALID_TYPE;
    }

    public boolean determineType() {
        int bestPriority = -1;
        boolean assignedType = false;
        for (BuildingType bt : BuildingTypes.getInstance()) {
            if (bt.priority() <= bestPriority) continue;
            Map<ResourceLocation, List<BlockPos>> available = bt.getGroups(this.blocks);
            boolean valid = bt.getGroups().entrySet().stream().noneMatch(e -> !available.containsKey(e.getKey()) || ((List)available.get(e.getKey())).size() < (Integer)e.getValue());
            if (!valid) continue;
            bestPriority = bt.priority();
            this.type = bt.name();
            assignedType = true;
        }
        return assignedType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTypeForced() {
        return this.isTypeForced;
    }

    public void setTypeForced(boolean forced) {
        this.isTypeForced = forced;
    }

    public BuildingType getBuildingType() {
        return BuildingTypes.getInstance().getBuildingType(this.type);
    }

    public Map<ResourceLocation, List<BlockPos>> getBlocks() {
        return this.blocks;
    }

    public void addBlock(Block block, BlockPos p) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        this.blocks.computeIfAbsent(key, k -> new ArrayList());
        this.blocks.get(key).add(p);
    }

    public void removeBlock(Block block, BlockPos p) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (this.blocks.containsKey(key)) {
            this.blocks.get(key).remove(p);
        }
    }

    public int getBlockCount() {
        return this.blocks.values().stream().mapToInt(List::size).sum();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean overlaps(Building b) {
        return this.pos1X > b.pos0X && this.pos0X < b.pos1X && this.pos1Y > b.pos0Y && this.pos0Y < b.pos1Y && this.pos1Z > b.pos0Z && this.pos0Z < b.pos1Z;
    }

    public boolean containsPos(Vec3i pos) {
        if (this.getBuildingType().grouped()) {
            return pos.closerThan((Vec3i)this.getCenter(), (double)this.getBuildingType().getMargin());
        }
        return pos.getX() >= this.pos0X && pos.getX() <= this.pos1X && pos.getY() >= this.pos0Y && pos.getY() <= this.pos1Y && pos.getZ() >= this.pos0Z && pos.getZ() <= this.pos1Z;
    }

    public boolean isIdentical(Building b) {
        return this.pos0X == b.pos0X && this.pos1X == b.pos1X && this.pos0Y == b.pos0Y && this.pos1Y == b.pos1Y && this.pos0Z == b.pos0Z && this.pos1Z == b.pos1Z;
    }

    public int getSize() {
        return this.size;
    }

    public long getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(long lastScan) {
        this.lastScan = lastScan;
    }

    public boolean isStrictScan() {
        return this.strictScan;
    }

    public boolean isComplete() {
        BuildingType bt = this.getBuildingType();
        int minBlocks = bt.getMinBlocks();
        return minBlocks == 0 || this.getBlockCount() >= minBlocks;
    }

    public static enum validationResult {
        OVERLAP,
        BLOCK_LIMIT,
        SIZE_LIMIT,
        NO_DOOR,
        TOO_SMALL,
        IDENTICAL,
        SUCCESS,
        INVALID_TYPE;

    }
}

