/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongFunction;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;

public class GraveyardManager
extends SavedData {
    private final Map<TombstoneState, Long2ObjectMap<ChunkBase>> tombstones = new EnumMap<TombstoneState, Long2ObjectMap<ChunkBase>>(TombstoneState.class);

    public GraveyardManager(ServerLevel world) {
    }

    public GraveyardManager(CompoundTag nbt, HolderLookup.Provider provider) {
        this.tombstones.putAll(NbtHelper.toMap(nbt, TombstoneState::valueOf, v -> {
            CompoundTag vv = (CompoundTag)v;
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            vv.getAllKeys().forEach(arg_0 -> GraveyardManager.lambda$new$0((Long2ObjectMap)map, vv, arg_0));
            return map;
        }));
    }

    public static GraveyardManager get(ServerLevel world) {
        return WorldUtils.loadData(world, GraveyardManager::new, GraveyardManager::new, "mca_graveyard");
    }

    private static long getChunkPos(BlockPos pos) {
        return ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)pos.getX()), (int)SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            this.tombstones.forEach((state, chunks) -> {
                CompoundTag chunkList = new CompoundTag();
                chunks.long2ObjectEntrySet().forEach(entry -> {
                    if (!((ChunkBase)entry.getValue()).isEmpty()) {
                        chunkList.put(String.valueOf(entry.getLongKey()), (Tag)((ChunkBase)entry.getValue()).toNbt());
                    }
                });
                if (!chunkList.isEmpty()) {
                    nbt.put(state.name(), (Tag)chunkList);
                }
            });
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTombstoneState(BlockPos pos, TombstoneState state) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(state.opposite(), l, ChunkBase::empty).removePos(pos);
            this.getChunk(state, l, Chunk::new).addPos(pos);
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTombstoneState(BlockPos pos) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).removePos(pos);
            this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).removePos(pos);
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockPos> findAll(AABB box, boolean includeEmpty, boolean includeFilled) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (includeEmpty || includeFilled) {
            int minX = Mth.floor((double)((box.minX - 2.0) / 16.0));
            int maxX = Mth.ceil((double)((box.maxX + 2.0) / 16.0));
            int minZ = Mth.floor((double)((box.minZ - 2.0) / 16.0));
            int maxZ = Mth.ceil((double)((box.maxZ + 2.0) / 16.0));
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
            synchronized (map) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        long l = ChunkPos.asLong((int)x, (int)z);
                        if (includeEmpty) {
                            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).appendAll(box, mutable, positions);
                        }
                        if (!includeFilled) continue;
                        this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).appendAll(box, mutable, positions);
                    }
                }
            }
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BlockPos> findNearest(BlockPos pos, TombstoneState state, int maxChunkRange) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            return this.getChunk(state, GraveyardManager.getChunkPos(pos), ChunkBase::empty).findNearest(pos, mutable).or(() -> {
                BlockPos center = new BlockPos(SectionPos.blockToSectionCoord((int)pos.getX()), 0, SectionPos.blockToSectionCoord((int)pos.getZ()));
                return BlockPos.withinManhattanStream((BlockPos)center, (int)maxChunkRange, (int)0, (int)maxChunkRange).map(p -> ChunkPos.asLong((int)p.getX(), (int)p.getZ())).map(l -> this.getChunk(state, (long)l, ChunkBase::empty).findNearest(pos, mutable)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(a -> a.distSqr((Vec3i)pos)));
            });
        }
    }

    private ChunkBase getChunk(TombstoneState state, long pos, LongFunction<ChunkBase> fallback) {
        Long2ObjectMap chunks = this.tombstones.computeIfAbsent(state, n -> new Long2ObjectOpenHashMap());
        ChunkBase chunk = (ChunkBase)chunks.get(pos);
        if (chunk == null && (chunk = fallback.apply(pos)) != ChunkBase.EMPTY) {
            chunks.put(pos, (Object)chunk);
        }
        return chunk;
    }

    public void reportToVillageManager(Entity entity) {
        VillageManager manager = VillageManager.get((ServerLevel)entity.level());
        GraveyardManager.get((ServerLevel)entity.level()).findAll(entity.getBoundingBox().inflate(24.0), true, true).stream().filter(p -> !manager.cache.contains(p)).forEach(manager::processBuilding);
    }

    private static /* synthetic */ void lambda$new$0(Long2ObjectMap map, CompoundTag vv, String key) {
        map.put(Long.parseLong(key), (Object)new Chunk((ListTag)vv.get(key)));
    }

    public static enum TombstoneState {
        EMPTY,
        FILLED;


        TombstoneState opposite() {
            return this == EMPTY ? FILLED : EMPTY;
        }
    }

    private static class ChunkBase {
        static final ChunkBase EMPTY = new ChunkBase();

        private ChunkBase() {
        }

        static ChunkBase empty(long l) {
            return EMPTY;
        }

        public boolean isEmpty() {
            return true;
        }

        public ListTag toNbt() {
            return new ListTag();
        }

        public void removePos(BlockPos pos) {
        }

        public void addPos(BlockPos pos) {
        }

        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.MutableBlockPos mutable) {
            return Optional.empty();
        }

        public void appendAll(AABB box, BlockPos.MutableBlockPos mutable, List<BlockPos> positions) {
        }
    }

    private static class Chunk
    extends ChunkBase {
        private final LongSet tombstones = new LongArraySet();

        Chunk(long l) {
        }

        Chunk(ListTag list) {
            list.forEach(l -> this.tombstones.add(((NumericTag)l).getAsLong()));
        }

        @Override
        public boolean isEmpty() {
            return this.tombstones.isEmpty();
        }

        @Override
        public ListTag toNbt() {
            ListTag list = new ListTag();
            this.tombstones.forEach(l -> list.add((Object)LongTag.valueOf((long)l)));
            return list;
        }

        @Override
        public void removePos(BlockPos pos) {
            this.tombstones.remove(pos.asLong());
        }

        @Override
        public void addPos(BlockPos pos) {
            this.tombstones.add(pos.asLong());
        }

        @Override
        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.MutableBlockPos mutable) {
            double distance = Double.MAX_VALUE;
            long nearest = -1L;
            boolean found = false;
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.set(l);
                double d = pos.distSqr((Vec3i)mutable);
                if (!(d < distance)) continue;
                distance = d;
                nearest = l;
                found = true;
            }
            return found ? Optional.of(BlockPos.of((long)nearest)) : Optional.empty();
        }

        @Override
        public void appendAll(AABB box, BlockPos.MutableBlockPos mutable, List<BlockPos> positions) {
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.set(l);
                if (!box.contains((double)mutable.getX(), (double)mutable.getY(), (double)mutable.getZ())) continue;
                positions.add(mutable.immutable());
            }
        }
    }
}

