/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.entity.ai.relationship.RelationshipType;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.ShowToastRequest;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.resources.API;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSaveData
extends SavedData
implements EntityRelationship {
    private final ServerLevel world;
    private final UUID uuid;
    private final List<Letter> inbox = new LinkedList<Letter>();
    private Optional<Integer> lastSeenVillage = Optional.empty();
    private boolean entityDataSet;
    private CompoundTag entityData;

    PlayerSaveData(ServerLevel world, UUID uuid) {
        this.world = world;
        this.uuid = uuid;
        this.resetEntityData();
    }

    PlayerSaveData(ServerLevel world, UUID uuid, CompoundTag nbt) {
        this.world = world;
        this.uuid = uuid;
        this.lastSeenVillage = nbt.contains("lastSeenVillage", 3) ? Optional.of(nbt.getInt("lastSeenVillage")) : Optional.empty();
        boolean bl = this.entityDataSet = nbt.contains("entityDataSet") && nbt.getBoolean("entityDataSet");
        if (nbt.contains("entityData")) {
            this.entityData = nbt.getCompound("entityData");
        } else {
            this.resetEntityData();
        }
        ListTag inbox = nbt.getList("inbox", 10);
        NbtHelper.toList((Tag)inbox, e -> new Letter((CompoundTag)e, (HolderLookup.Provider)world.registryAccess()));
    }

    public static PlayerSaveData get(ServerPlayer player) {
        return PlayerSaveData.get((ServerLevel)player.level(), player.getUUID());
    }

    public static PlayerSaveData get(ServerLevel world, UUID uuid) {
        return WorldUtils.loadData(world.getServer().overworld(), (nbt, provider) -> new PlayerSaveData(world, uuid, (CompoundTag)nbt), w -> new PlayerSaveData(world, uuid), "mca_player_" + String.valueOf(uuid));
    }

    public static Optional<PlayerSaveData> getIfPresent(ServerLevel world, UUID uuid) {
        return Optional.ofNullable((PlayerSaveData)world.getDataStorage().get(new SavedData.Factory(() -> null, (nbt, provider) -> new PlayerSaveData(world, uuid, (CompoundTag)nbt), null), "mca_player_" + String.valueOf(uuid)));
    }

    public static void showMailNotification(ServerPlayer player) {
        Network.sendToPlayer(new ShowToastRequest("server.mail.title", "server.mail.description"), player);
    }

    private void resetEntityData() {
        this.entityData = new CompoundTag();
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)this.world);
        assert (villager != null);
        villager.initializeSkin(true);
        villager.getGenetics().randomize();
        villager.getTraits().randomize();
        villager.getVillagerBrain().randomize();
        villager.addAdditionalSaveData(this.entityData);
    }

    public boolean isEntityDataSet() {
        return this.entityDataSet;
    }

    public void setEntityDataSet(boolean entityDataSet) {
        this.entityDataSet = entityDataSet;
    }

    public CompoundTag getEntityData() {
        return this.entityData;
    }

    public void setEntityData(CompoundTag entityData) {
        this.entityData = entityData;
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        EntityRelationship.super.onTragedy(cause, burialSite, type, victim);
        if (victim instanceof VillagerEntityMCA) {
            VillagerEntityMCA victimVillager = (VillagerEntityMCA)victim;
            this.sendLetterOfCondolence(victimVillager.getName().getString(), victimVillager.getResidency().getHomeVillage().map(Village::getName).orElse(API.getVillagePool().pickVillageName("village")));
        }
    }

    public void updateLastSeenVillage(VillageManager manager, ServerPlayer self) {
        Optional<Village> prevVillage = this.getLastSeenVillage(manager);
        Optional<Village> nextVillage = prevVillage.filter(v -> v.isWithinBorder((Entity)self)).or(() -> manager.findNearestVillage((Entity)self));
        this.setLastSeenVillage(self, prevVillage.orElse(null), nextVillage.orElse(null));
        if (nextVillage.isPresent()) {
            Rank rank = Tasks.getRank(nextVillage.get(), self);
            CriterionMCA.RANK.trigger(self, rank);
        }
    }

    public void setLastSeenVillage(ServerPlayer self, Village oldVillage, @Nullable Village newVillage) {
        this.lastSeenVillage = Optional.ofNullable(newVillage).map(Village::getId);
        this.setDirty();
        if (oldVillage != newVillage) {
            if (oldVillage != null) {
                this.onLeave((Player)self, oldVillage);
            }
            if (newVillage != null) {
                this.onEnter((Player)self, newVillage);
            }
        }
    }

    public Optional<Village> getLastSeenVillage(VillageManager manager) {
        return this.lastSeenVillage.flatMap(manager::getOrEmpty);
    }

    public Optional<Integer> getLastSeenVillageId() {
        return this.lastSeenVillage;
    }

    protected void onLeave(Player self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.displayClientMessage((Component)Component.translatable((String)"gui.village.left", (Object[])new Object[]{village.getName()}).withStyle(ChatFormatting.GOLD), true);
        }
    }

    protected void onEnter(Player self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.displayClientMessage((Component)Component.translatable((String)"gui.village.welcome", (Object[])new Object[]{village.getName()}).withStyle(ChatFormatting.GOLD), true);
        }
        village.onEnter(this.world);
    }

    @Override
    public void marry(Entity spouse) {
        EntityRelationship.super.marry(spouse);
        this.setDirty();
    }

    @Override
    public void endRelationShip(RelationshipState newState) {
        EntityRelationship.super.endRelationShip(newState);
        this.setDirty();
    }

    @Override
    public ServerLevel getWorld() {
        return this.world;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Gender getGender() {
        return Gender.byId(this.getEntityData().getInt("gender"));
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrEmpty(this.uuid).orElseGet(() -> {
            String name = Optional.ofNullable(this.world.getPlayerByUUID(this.uuid)).map(p -> p.getName().getString()).orElse("Unnamed Adventurer");
            return this.getFamilyTree().getOrCreate(this.uuid, name, this.getGender(), true);
        });
    }

    public void reset() {
        this.endRelationShip(RelationshipState.SINGLE);
        this.setDirty();
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        this.lastSeenVillage.ifPresent(id -> nbt.putInt("lastSeenVillage", id.intValue()));
        nbt.put("entityData", (Tag)this.entityData);
        nbt.putBoolean("entityDataSet", this.entityDataSet);
        nbt.put("inbox", (Tag)NbtHelper.fromList(this.inbox, v -> v.toTag(provider)));
        return nbt;
    }

    public void sendMail(Letter pages) {
        if (Config.getInstance().enableVillagerMailingPlayers) {
            this.inbox.add(pages);
        }
        this.setDirty();
    }

    public boolean hasMail() {
        return !this.inbox.isEmpty();
    }

    public ItemStack getMail() {
        if (this.hasMail()) {
            Letter letter = this.inbox.removeFirst();
            ItemStack stack = new ItemStack((ItemLike)ItemsMCA.LETTER, 1);
            stack.set(DataComponentsMCA.BOOK_PAGES, letter.pages());
            return stack;
        }
        return null;
    }

    public void sendLetterOfCondolence(String name, String village) {
        this.sendLetter(new Component[]{Component.translatable((String)"mca.letter.condolence", (Object[])new Object[]{this.getFamilyEntry().getName(), name, village})});
    }

    public void sendLetter(Component ... lines) {
        this.sendMail(new Letter("", Arrays.asList(lines)));
        Optional.ofNullable(this.world.getPlayerByUUID(this.uuid)).ifPresent(p -> PlayerSaveData.showMailNotification((ServerPlayer)p));
    }

    public record Letter(String title, List<Component> pages) {
        private static final Codec<List<Component>> PAGES_CODEC = ComponentSerialization.FLAT_CODEC.listOf();

        public Letter(CompoundTag nbt, HolderLookup.Provider registries) {
            this(nbt.getString("title"), PAGES_CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.getCompound("pages")).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).orElse(List.of()));
        }

        CompoundTag toTag(HolderLookup.Provider registries) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("title", this.title);
            RegistryOps dynamicOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ComponentSerialization.FLAT_CODEC.listOf().encodeStart((DynamicOps)dynamicOps, this.pages).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("pages", tag));
            return nbt;
        }
    }
}

