/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.Map;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.util.MaxSizeHashMap;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class VillagerTrackerManager
extends SavedData {
    private static final int MAP_SIZE = 16384;
    private final Map<UUID, GlobalPos> entries = new MaxSizeHashMap<UUID, GlobalPos>(16384);

    VillagerTrackerManager(ServerLevel world) {
    }

    VillagerTrackerManager(CompoundTag nbt, HolderLookup.Provider provider) {
        this.entries.putAll(NbtHelper.toMap(nbt, UUID::fromString, (id, element) -> NbtHelper.decodeGlobalPos(element)));
    }

    public static VillagerTrackerManager get(ServerLevel world) {
        return WorldUtils.loadData(world.getServer().overworld(), VillagerTrackerManager::new, VillagerTrackerManager::new, "mca_villager_tracker");
    }

    public static void update(Entity entity) {
        Level level;
        if (Config.getInstance().trackVillagerPosition && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            VillagerTrackerManager.get(serverWorld).set(entity);
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        return NbtHelper.fromMap(nbt, this.entries, UUID::toString, NbtHelper::encodeGlobalPosition);
    }

    public void remove(UUID id) {
        this.entries.remove(id);
        this.setDirty();
    }

    public void set(Entity entity) {
        this.entries.put(entity.getUUID(), GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)entity.blockPosition()));
    }

    public GlobalPos get(UUID id) {
        return this.entries.get(id);
    }
}

