/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;

public class VillageInnManager {
    private final Village village;

    public VillageInnManager(Village village) {
        this.village = village;
    }

    public void updateInn(ServerLevel world) {
        this.village.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                BlockPos p;
                if (!(world.random.nextFloat() < Config.getInstance().adventurerAtInnChancePerMinute)) break block1;
                ArrayList values = new ArrayList(b.getBlocks().values().stream().flatMap(Collection::stream).toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (BlockPos)iterator.next()).above())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(BlockGetter world, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.above())) {
            if (world.getBlockState(blockPos).getCollisionShape(world, blockPos).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(ServerLevel world, BlockPos blockPos) {
        if (!world.isPositionEntityTicking(blockPos)) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((BlockGetter)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.random.nextInt(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                WanderingTrader trader = (WanderingTrader)EntityType.WANDERING_TRADER.spawn(world, blockPos, MobSpawnType.EVENT);
                if (trader != null) {
                    name = trader.getName().getString();
                    trader.setDespawnDelay(Config.getInstance().adventurerStayTime);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().spawn(world, blockPos, MobSpawnType.EVENT);
                if (adventurer2 != null) {
                    name = adventurer2.getName().getString();
                    adventurer2.setProfession(ProfessionsMCA.CULTIST);
                    adventurer2.setDespawnDelay(Config.getInstance().adventurerStayTime);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().spawn(world, blockPos, MobSpawnType.EVENT)) != null) {
                name = adventurer.getName().getString();
                adventurer.setProfession(ProfessionsMCA.ADVENTURER);
                adventurer.setDespawnDelay(Config.getInstance().adventurerStayTime);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.village.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }
}

