/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.resources.PoolUtil;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class VillageProcreationManager {
    private final Village village;

    public VillageProcreationManager(Village village) {
        this.village = village;
    }

    public void procreate(ServerLevel world) {
        int maxPopulation;
        if (world.random.nextFloat() >= Config.getInstance().villagerProcreationChancePerMinute) {
            return;
        }
        int population = this.village.getPopulation();
        if ((float)population >= (float)(maxPopulation = this.village.getMaxPopulation()) * this.village.getPopulationThreshold()) {
            return;
        }
        PoolUtil.pick(this.village.getResidents(world), world.random).filter(villager -> villager.getGenetics().getGender() == Gender.FEMALE).filter(villager -> (double)world.random.nextFloat() < 1.0 / ((double)FamilyTree.get(world).getOrCreate((Entity)villager).getChildren().count() + 0.1)).filter(villager -> villager.getRelationships().getPregnancy().tryStartGestation()).ifPresent(villager -> villager.getRelationships().getPartner().ifPresent(spouse -> {
            if (Config.getInstance().villagerBirthNotification && spouse instanceof VillagerEntityMCA) {
                VillagerEntityMCA spouseVillager = (VillagerEntityMCA)spouse;
                this.village.broadCastMessage(world, "events.baby", (VillagerEntityMCA)villager, spouseVillager);
            }
        }));
    }
}

