/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VillageTaxesManager {
    private static final int MAX_STORAGE_SIZE = 1024;
    private final Village village;

    public VillageTaxesManager(Village village) {
        this.village = village;
    }

    public void taxes(ServerLevel world) {
        MutableComponent msg;
        double taxes = (double)(Config.getInstance().taxesFactor * (float)this.village.getPopulation() * this.village.getTaxes()) + world.random.nextDouble();
        int moodImpact = 0;
        float r = this.village.getTaxes() + (world.random.nextFloat() - 0.5f) * world.random.nextFloat();
        if (this.village.getTaxes() == 0.0f) {
            msg = Component.translatable((String)"gui.village.taxes.no", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.GREEN);
            moodImpact = 5;
            taxes = 0.0;
        } else if ((double)r < 0.1) {
            msg = Component.translatable((String)"gui.village.taxes.more", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.GREEN);
            taxes += (double)this.village.getPopulation() * 0.25;
        } else if ((double)r < 0.3) {
            msg = Component.translatable((String)"gui.village.taxes.happy", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.DARK_GREEN);
            moodImpact = 5;
        } else if ((double)r < 0.7) {
            msg = Component.translatable((String)"gui.village.taxes", (Object[])new Object[]{this.village.getName()});
        } else if ((double)r < 0.8) {
            msg = Component.translatable((String)"gui.village.taxes.sad", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.GOLD);
            moodImpact = -5;
        } else if ((double)r < 0.9) {
            msg = Component.translatable((String)"gui.village.taxes.angry", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.RED);
            moodImpact = -10;
        } else {
            msg = Component.translatable((String)"gui.village.taxes.riot", (Object[])new Object[]{this.village.getName()}).withStyle(ChatFormatting.DARK_RED);
            taxes = 0.0;
        }
        world.players().stream().filter(v -> Tasks.getRank(this.village, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> VillageTaxesManager.lambda$taxes$1((Component)msg, arg_0));
        if (this.village.hasBuilding("library")) {
            taxes *= 1.5;
        }
        while (taxes > 0.0) {
            double finalTaxes = taxes;
            List<String> valids = Config.getInstance().taxesMap.entrySet().stream().filter(e -> (double)(((Float)e.getValue()).floatValue() * world.random.nextFloat()) < finalTaxes).map(Map.Entry::getKey).toList();
            if (valids.isEmpty()) break;
            String itemName = valids.get(world.random.nextInt(valids.size()));
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName));
            if (item == Items.AIR) {
                throw new RuntimeException("The taxes map contains an invalid item %s!".formatted(itemName));
            }
            taxes -= (double)Config.getInstance().taxesMap.get(itemName).floatValue();
            Optional<ItemStack> stack = this.village.storageBuffer.stream().filter(i -> i.is(item) && i.getCount() < i.getMaxStackSize()).findAny();
            if (stack.isPresent()) {
                stack.get().grow(1);
                continue;
            }
            if (this.village.storageBuffer.size() >= 1024) continue;
            this.village.storageBuffer.add(new ItemStack((ItemLike)item, 1));
        }
        if (moodImpact != 0) {
            this.village.pushMood(moodImpact);
        }
        this.deliverTaxes(world);
    }

    public void deliverTaxes(ServerLevel world) {
        if (this.village.hasStoredResource() && WorldUtils.isChunkLoaded(world, this.village.getCenter())) {
            this.village.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.village.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (BlockPos)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(ServerLevel world, BlockPos p) {
        BlockEntity blockEntity;
        BlockState state = world.getBlockState(p);
        if (state.hasBlockEntity() && (blockEntity = world.getBlockEntity(p)) instanceof Container) {
            ChestBlock chest;
            Container inventory = (Container)blockEntity;
            Block block = state.getBlock();
            if (inventory instanceof ChestBlockEntity && block instanceof ChestBlock && (inventory = ChestBlock.getContainer((ChestBlock)(chest = (ChestBlock)block), (BlockState)state, (Level)world, (BlockPos)p, (boolean)true)) != null) {
                this.putIntoInventory(inventory);
            }
        }
    }

    private void putIntoInventory(Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                ItemStack stack = inventory.getItem(i);
                ItemStack tax = this.village.storageBuffer.getFirst();
                if (stack.getItem() == tax.getItem()) {
                    int diff = Math.min(tax.getCount(), stack.getMaxStackSize() - stack.getCount());
                    if (diff > 0) {
                        stack.grow(diff);
                        tax.shrink(diff);
                        if (tax.isEmpty()) {
                            this.village.storageBuffer.removeFirst();
                            changes = true;
                        }
                        inventory.setChanged();
                    }
                } else if (stack.isEmpty()) {
                    inventory.setItem(i, tax);
                    inventory.setChanged();
                    this.village.storageBuffer.removeFirst();
                    changes = true;
                }
                if (this.village.hasStoredResource()) continue;
                return;
            }
        }
    }

    private static /* synthetic */ void lambda$taxes$1(Component msg, ServerPlayer player) {
        player.displayClientMessage(msg, true);
    }
}

