/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util.network.datasync;

import java.util.Optional;
import java.util.UUID;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.NbtCompoundDefaultGetters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public interface CParameter<T, TrackedType> {
    public static CDataParameter<Integer> create(String id, int def) {
        return new CDataParameter<Integer>(id, EntityDataSerializers.INT, def, (nbt, key, provider) -> NbtCompoundDefaultGetters.getInt(nbt, key, def), (nbt, key, value, provider) -> nbt.putInt(key, value.intValue()));
    }

    public static CDataParameter<Float> create(String id, float def) {
        return new CDataParameter<Float>(id, EntityDataSerializers.FLOAT, Float.valueOf(def), (nbt, key, provider) -> Float.valueOf(NbtCompoundDefaultGetters.getFloat(nbt, key, def)), (nbt, key, value, provider) -> nbt.putFloat(key, value.floatValue()));
    }

    public static CDataParameter<Boolean> create(String id, boolean def) {
        return new CDataParameter<Boolean>(id, EntityDataSerializers.BOOLEAN, def, (nbt, key, provider) -> {
            if (nbt.contains(key)) {
                return nbt.getInt(key) != 0;
            }
            return def;
        }, (nbt, key, value, provider) -> nbt.putInt(key, value != false ? 1 : 0));
    }

    public static CDataParameter<String> create(String id, String def) {
        return new CDataParameter<String>(id, EntityDataSerializers.STRING, def, (nbt, key, provider) -> NbtCompoundDefaultGetters.getString(nbt, key, def), (nbt, key, value, provider) -> nbt.putString(key, value));
    }

    public static CDataParameter<CompoundTag> create(String id, CompoundTag def) {
        return new CDataParameter<CompoundTag>(id, EntityDataSerializers.COMPOUND_TAG, def, (nbt, key, provider) -> NbtCompoundDefaultGetters.getCompound(nbt, key, def), (nbt, key, value, provider) -> nbt.put(key, (Tag)value));
    }

    public static CDataParameter<ItemStack> create(String id, ItemStack def) {
        return new CDataParameter<ItemStack>(id, EntityDataSerializers.ITEM_STACK, def, (nbt, key, provider) -> NbtCompoundDefaultGetters.getItemStack(nbt, key, ItemStack.EMPTY, (HolderLookup.Provider)provider), (nbt, key, stack, provider) -> {
            CompoundTag itemNbt = new CompoundTag();
            stack.save((HolderLookup.Provider)provider, (Tag)itemNbt);
            nbt.put(key, (Tag)itemNbt);
        });
    }

    public static CDataParameter<BlockPos> create(String id, BlockPos def) {
        return new CDataParameter<BlockPos>(id, EntityDataSerializers.BLOCK_POS, def, (tag, key, provider) -> new BlockPos(tag.getInt(key + "X"), tag.getInt(key + "Y"), tag.getInt(key + "Z")), (tag, key, pos, provider) -> {
            tag.putInt(key + "X", pos.getX());
            tag.putInt(key + "Y", pos.getY());
            tag.putInt(key + "Z", pos.getZ());
        });
    }

    public static CDataParameter<Optional<UUID>> create(String id, Optional<UUID> def) {
        return new CDataParameter<Optional<UUID>>(id, EntityDataSerializers.OPTIONAL_UUID, def, (tag, key, provider) -> tag.hasUUID(key) ? Optional.of(tag.getUUID(key)) : Optional.empty(), (tag, key, v, provider) -> v.ifPresent(uuid -> tag.putUUID(key, uuid)));
    }

    public static <T extends Enum<T>> CEnumParameter<T> create(String id, T def) {
        return new CEnumParameter(id, def.getClass(), def);
    }

    public static <T extends Enum<T>> CEnumParameter<T> create(String id, Class<T> type) {
        return new CEnumParameter<Object>(id, type, null);
    }

    public TrackedType getDefault();

    public T get(EntityDataAccessor<TrackedType> var1, SynchedEntityData var2);

    public void set(EntityDataAccessor<TrackedType> var1, SynchedEntityData var2, T var3);

    public T load(CompoundTag var1, RegistryAccess var2);

    public void save(CompoundTag var1, T var2, RegistryAccess var3);

    public EntityDataAccessor<TrackedType> createParam(Class<? extends Entity> var1);
}

