/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks.SophisticatedBackpackAttributes;
import xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks.util.SophisticatedBackpackUtil;

public class BackpackHasUUIDAttribute
implements ItemAttribute {
    private String UUID;

    public BackpackHasUUIDAttribute(String UUID2) {
        this.UUID = UUID2;
    }

    public boolean appliesTo(ItemStack itemStack, Level level) {
        String uuid = SophisticatedBackpackUtil.getBackpackUUID(itemStack);
        return uuid != null && uuid.equals(this.UUID);
    }

    public ItemAttributeType getType() {
        return SophisticatedBackpackAttributes.HAS_BACKPACK_UUID;
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.m_128359_("UUID", this.UUID);
    }

    public void load(CompoundTag compoundTag) {
        this.UUID = compoundTag.m_128461_("UUID");
    }

    public String getTranslationKey() {
        return "has_backpack_uuid";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.UUID};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new BackpackHasUUIDAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = SophisticatedBackpackUtil.getBackpackUUID(stack);
            if (name != null && !name.isEmpty()) {
                list.add(new BackpackHasUUIDAttribute(name));
            }
            return list;
        }
    }
}

