/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks.SophisticatedBackpackAttributes;
import xyz.iwolfking.createfiltersanywhere.api.attributes.impl.sophisticatedbackpacks.util.SophisticatedBackpackUtil;

public class BackpackHasUpgradeAttribute
implements ItemAttribute {
    private String upgrade;

    public BackpackHasUpgradeAttribute(@Nullable String upgrade) {
        this.upgrade = upgrade;
    }

    public boolean appliesTo(ItemStack itemStack, Level level) {
        if (itemStack.m_41720_() instanceof BackpackItem) {
            return SophisticatedBackpackUtil.getUpgrades(itemStack).contains(this.upgrade);
        }
        return false;
    }

    public ItemAttributeType getType() {
        return SophisticatedBackpackAttributes.HAS_BACKPACK_UPGRADE;
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.m_128359_("upgrade", this.upgrade);
    }

    public void load(CompoundTag compoundTag) {
        this.upgrade = compoundTag.m_128461_("upgrade");
    }

    public String getTranslationKey() {
        return "has_backpack_upgrade";
    }

    public Object[] getTranslationParameters() {
        String modifiedItemName = this.upgrade.replace("[", "").replace("]", "").trim();
        return new Object[]{modifiedItemName};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new BackpackHasUpgradeAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            List<String> upgrades = SophisticatedBackpackUtil.getUpgrades(stack);
            if (!upgrades.isEmpty()) {
                for (String upgrade : upgrades) {
                    list.add(new BackpackHasUpgradeAttribute(upgrade));
                }
            }
            return list;
        }
    }
}

