/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.api.core;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.lang.invoke.MethodHandle;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import xyz.iwolfking.createfiltersanywhere.CreateFiltersAnywhere;
import xyz.iwolfking.createfiltersanywhere.CreateVersion;
import xyz.iwolfking.createfiltersanywhere.api.compat.AE2KeyHandler;
import xyz.iwolfking.createfiltersanywhere.api.core.CFACache;

public class CFATests {
    public static String filterKey = "hashes";
    private static MethodHandle testMethodHandle;
    private static Level level;

    public static boolean checkFilter(ItemStack stack, Object filterStack, boolean useCache, Level level) {
        if (!useCache) {
            return CFATests.basicFilterTest(stack, filterStack, level);
        }
        Item stackItem = stack.m_41720_();
        return CFACache.getOrCreateFilter(stack, filterStack, level);
    }

    public static boolean basicFilterTest(ItemStack stack, Object filterStack, Level level) {
        if (level == null) {
            level = FMLLoader.getDist() == Dist.CLIENT ? CFATests.getClientLevel() : CFATests.level;
        }
        if (CreateVersion.getLoadedVersion().equals((Object)CreateVersion.CREATE_06)) {
            if (filterStack instanceof ItemStack) {
                ItemStack stackFilter = (ItemStack)filterStack;
                return FilterItemStack.of((ItemStack)stackFilter).test(level, stack);
            }
            if (filterStack instanceof FilterItemStack) {
                FilterItemStack filterItemStack = (FilterItemStack)filterStack;
                return filterItemStack.test(level, stack);
            }
            if (LoadingModList.get().getModFileById("ae2") != null) {
                return AE2KeyHandler.handleAEKey(stack, filterStack, level);
            }
            CreateFiltersAnywhere.LOGGER.debug("[6.0.1] invalid filter entered");
            return false;
        }
        CreateFiltersAnywhere.LOGGER.debug("Your Create version is not supported yet! Disabling functionality.");
        return false;
    }

    public static boolean noCacheDetailedTest(ItemStack stack, Object filterStack, Level level) {
        return CFATests.basicFilterTest(stack, filterStack, level);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        MinecraftServer server = event.getLevel().m_7654_();
        if (server != null) {
            level = server.m_129880_(Level.f_46428_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

