/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.mixin.compat.ae2;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.parts.automation.HandlerStrategy;
import appeng.parts.automation.StorageExportStrategy;
import appeng.util.BlockApiCache;
import com.simibubi.create.content.logistics.filter.FilterItem;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.Direction;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.createfiltersanywhere.Config;
import xyz.iwolfking.createfiltersanywhere.api.compat.AE2KeyHandler;

@Restriction(require={@Condition(value="ae2")})
@Mixin(value={StorageExportStrategy.class}, remap=false)
public abstract class MixinStorageExportStrategy<C, S>
implements StackExportStrategy {
    @Shadow
    @Final
    private HandlerStrategy<C, S> handlerStrategy;
    @Shadow
    @Final
    private Direction fromSide;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private BlockApiCache<C> apiCache;

    @Overwrite
    public long transfer(StackTransferContext context, AEKey what, long amount) {
        long extracted;
        long wasInserted;
        if (!this.handlerStrategy.isSupported(what)) {
            return 0L;
        }
        Object adjacentStorage = this.apiCache.find(this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (((Boolean)Config.AE2_COMPAT.get()).booleanValue() && itemKey.getItem() instanceof FilterItem) {
                for (Object2LongMap.Entry key : inv.getInventory().getAvailableStacks()) {
                    AEItemKey itemKey2;
                    AEKey aek = (AEKey)key.getKey();
                    if (!(aek instanceof AEItemKey) || !AE2KeyHandler.checkFilter(itemKey2 = (AEItemKey)aek, itemKey, true, null)) continue;
                    what = aek;
                    break;
                }
            }
        }
        if ((wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE), Actionable.SIMULATE)) > 0L && (wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)wasInserted, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE), Actionable.MODULATE)) < extracted) {
            long leftover = extracted - wasInserted;
            if ((leftover -= inv.getInventory().insert(what, leftover, Actionable.MODULATE, context.getActionSource())) > 0L) {
                LOGGER.error("Storage export: adjacent block unexpectedly refused insert, voided {}x{}", (Object)leftover, (Object)what);
            }
        }
        return wasInserted;
    }
}

