/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.api.util.apotheosis;

import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.createfiltersanywhere.api.util.StringUtils;

public class ApotheosisUtil {
    public static boolean isGemItem(ItemStack stack) {
        return stack.getItem() instanceof GemItem;
    }

    public static Optional<Purity> getPurityOf(ItemStack stack) {
        if (ApotheosisUtil.isGemItem(stack)) {
            return Optional.ofNullable(GemItem.getPurity((ItemStack)stack));
        }
        return Optional.empty();
    }

    public static boolean isUniqueGem(ItemStack stack) {
        DynamicHolder gem;
        if (ApotheosisUtil.isGemItem(stack) && (gem = GemItem.getGem((ItemStack)stack)).getOptional().isPresent()) {
            return ((Gem)gem.get()).isUnique();
        }
        return false;
    }

    public static Set<GemBonus> getGemBonuses(ItemStack stack) {
        DynamicHolder gem;
        if (ApotheosisUtil.isGemItem(stack) && (gem = GemItem.getGem((ItemStack)stack)).getOptional().isPresent()) {
            return Set.copyOf(((Gem)gem.get()).getBonuses());
        }
        return Set.of();
    }

    public static Set<String> getGemBonusesTypeNames(ItemStack stack) {
        DynamicHolder gem;
        HashSet<String> names = new HashSet<String>();
        if (ApotheosisUtil.isGemItem(stack) && (gem = GemItem.getGem((ItemStack)stack)).getOptional().isPresent()) {
            ((Gem)gem.get()).getBonuses().forEach(bonus -> names.add(StringUtils.toTitleCase(bonus.getTypeKey().getPath())));
        }
        return names;
    }
}

