/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.attributes.impl.sophisticatedbackpacks;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.createfiltersanywhere.api.util.sophisticatedbackpacks.SophisticatedBackpackUtil;
import xyz.iwolfking.createfiltersanywhere.attributes.impl.sophisticatedbackpacks.SophisticatedBackpackAttributes;

public record BackpackHasUpgradeAttribute(String upgrade) implements ItemAttribute
{
    public static final MapCodec<BackpackHasUpgradeAttribute> CODEC = Codec.STRING.xmap(BackpackHasUpgradeAttribute::new, BackpackHasUpgradeAttribute::upgrade).fieldOf("value");
    public static final StreamCodec<ByteBuf, BackpackHasUpgradeAttribute> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(BackpackHasUpgradeAttribute::new, BackpackHasUpgradeAttribute::upgrade);

    public boolean appliesTo(ItemStack itemStack, Level level) {
        if (itemStack.getItem() instanceof BackpackItem) {
            return SophisticatedBackpackUtil.getUpgrades(itemStack).contains(this.upgrade);
        }
        return false;
    }

    public ItemAttributeType getType() {
        return SophisticatedBackpackAttributes.HAS_BACKPACK_UPGRADE;
    }

    public String getTranslationKey() {
        return "has_backpack_upgrade";
    }

    public Object[] getTranslationParameters() {
        String modifiedItemName = this.upgrade.replace("[", "").replace("]", "").trim();
        return new Object[]{modifiedItemName};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new BackpackHasUpgradeAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            List<String> upgrades = SophisticatedBackpackUtil.getUpgrades(stack);
            if (!upgrades.isEmpty()) {
                for (String upgrade : upgrades) {
                    list.add(new BackpackHasUpgradeAttribute(upgrade));
                }
            }
            return list;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

