/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.mixin.compat.refinedstorage;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.createfiltersanywhere.Config;
import xyz.iwolfking.createfiltersanywhere.api.core.CFAFilterSelector;

@Mixin(value={Filter.class}, remap=false)
public class MixinFilter {
    @Shadow
    private UnaryOperator<ResourceKey> normalizer;
    @Shadow
    @Final
    private Set<ResourceKey> filters;
    @Shadow
    private FilterMode mode;

    @Inject(method={"isAllowed"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkCreateFilter(ResourceKey resource, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.RS_COMPAT.get()).booleanValue()) {
            return;
        }
        ResourceKey normalized = (ResourceKey)this.normalizer.apply(resource);
        if (normalized instanceof ItemResource) {
            ItemResource normalizedItem = (ItemResource)normalized;
            for (ResourceKey filter : this.filters) {
                if (!(filter instanceof ItemResource)) continue;
                ItemResource itemResource = (ItemResource)filter;
                if (CFAFilterSelector.isSupportedFilterStack(itemResource.toItemStack())) {
                    if (this.mode.equals((Object)FilterMode.ALLOW)) {
                        cir.setReturnValue((Object)CFAFilterSelector.doFilterTest(normalizedItem.toItemStack(), itemResource.toItemStack()));
                        return;
                    }
                    cir.setReturnValue((Object)(!CFAFilterSelector.doFilterTest(normalizedItem.toItemStack(), itemResource.toItemStack()) ? 1 : 0));
                    return;
                }
                cir.setReturnValue((Object)(switch (this.mode) {
                    default -> throw new MatchException(null, null);
                    case FilterMode.ALLOW -> this.filters.contains(normalized);
                    case FilterMode.BLOCK -> !this.filters.contains(normalized);
                }));
                return;
            }
        }
    }
}

