/*
 * Decompiled with CFR 0.152.
 */
package com.ikairo.mixin;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin
extends ItemCombinerMenu {
    @Shadow
    private String itemName;
    @Shadow
    @Final
    private DataSlot cost;
    @Unique
    private boolean isDuplicating;
    @Unique
    private boolean isRemovingItem;

    @Shadow
    public abstract void createResult();

    public AnvilScreenHandlerMixin(int syncId, Inventory inventory) {
        super(null, syncId, inventory, null);
    }

    @Inject(method={"createResult()V"}, at={@At(value="HEAD")})
    protected void checkIsDuplicating(CallbackInfo ci) {
        if (!this.isRemovingItem) {
            this.isDuplicating = this.inputSlots.getItem(0).is(Items.BOOK) && this.inputSlots.getItem(1).has(DataComponents.STORED_ENCHANTMENTS);
        }
    }

    @Redirect(method={"createResult()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getCount()I"))
    private int onGetItemStackCount(ItemStack stack) {
        if (this.isDuplicating) {
            return 1;
        }
        return stack.getCount();
    }

    @ModifyVariable(method={"createResult()V"}, at=@At(value="STORE"), ordinal=3)
    private boolean onStoreIsEnchantAcceptable(boolean isAcceptable) {
        if (this.isDuplicating) {
            return true;
        }
        return isAcceptable;
    }

    @Inject(method={"createResult()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ResultContainer;setItem(ILnet/minecraft/world/item/ItemStack;)V", shift=At.Shift.AFTER)})
    private void afterSetResult(CallbackInfo ci) {
        if (this.isDuplicating && (!this.isRemovingItem || this.inputSlots.getItem(0).is(Items.BOOK))) {
            ItemStack result = this.inputSlots.getItem(1).copy();
            if (!(StringUtils.isBlank((CharSequence)this.itemName) || StringUtils.equals((CharSequence)this.itemName, (CharSequence)this.inputSlots.getItem(0).getHoverName().getString()) || StringUtils.equals((CharSequence)this.itemName, (CharSequence)this.inputSlots.getItem(0).getHoverName().getString()))) {
                result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
            }
            this.resultSlots.setItem(0, result);
        }
    }

    @Redirect(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=0))
    private void decrementWhenDuplicating(Container instance, int i, ItemStack itemStack) {
        this.isRemovingItem = true;
        if (this.inputSlots.getItem(0).getCount() > 1 && this.inputSlots.getItem(0).is(Items.BOOK) && !this.inputSlots.getItem(1).isEmpty()) {
            if (this.player instanceof ServerPlayer) {
                this.inputSlots.getItem(0).shrink(1);
            }
            this.createResult();
        } else {
            this.inputSlots.setItem(0, ItemStack.EMPTY);
        }
        this.isRemovingItem = false;
    }

    @Redirect(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=3))
    private void doNotSetInputSlot2Empty(Container instance, int i, ItemStack itemStack) {
        if (!this.isDuplicating) {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
    }

    @Redirect(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;set(I)V"))
    private void doNotResetLevelCost(DataSlot instance, int i) {
        if (!this.isDuplicating || !this.inputSlots.getItem(0).is(Items.BOOK)) {
            instance.set(i);
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        if (this.inputSlots.getItem(0).is(Items.BOOK) && slot == 2 && !this.inputSlots.getItem(1).isEmpty() && !player.hasInfiniteMaterials() && player.experienceLevel < this.cost.get()) {
            return this.inputSlots.getItem(slot);
        }
        return super.quickMoveStack(player, slot);
    }
}

