/*
 * Decompiled with CFR 0.152.
 */
package se.itssimple.zombieshateslight.ai;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import se.itssimple.zombieshateslight.ModCommon;

public class BreakLightSourcesGoal
extends Goal {
    protected final Zombie zombie;
    protected final Level level;
    private Path findingPath;
    private BlockPos targetLightPosition;
    private int breakingTime;
    private int breakingCooldown;
    private static final int MAX_BREAKING_TIME = 100;
    private static final int MAX_BREAKING_COOLDOWN = 200;
    private static final Integer LIGHT_SOURCE_RADIUS = (Integer)ModCommon.LIGHT_SOURCE_RADIUS.getValue();
    private static final TagKey<Block> AFFECTED_BLOCKS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("zombieshateslight", "affected_blocks"));

    public BreakLightSourcesGoal(Zombie zombie) {
        this.zombie = zombie;
        this.level = zombie.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.breakingCooldown = 0;
    }

    public boolean m_8036_() {
        if (this.breakingCooldown > 0) {
            --this.breakingCooldown;
            return false;
        }
        this.targetLightPosition = this.findNearestLightSource();
        return this.targetLightPosition != null;
    }

    private BlockPos findNearestLightSource() {
        BlockPos zombiePosition = this.zombie.m_20183_();
        AtomicReference foundPos = new AtomicReference();
        AtomicReference<Double> closestDistance = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        BlockPos.m_121990_((BlockPos)zombiePosition.m_7918_(-LIGHT_SOURCE_RADIUS.intValue(), -LIGHT_SOURCE_RADIUS.intValue(), -LIGHT_SOURCE_RADIUS.intValue()), (BlockPos)zombiePosition.m_7918_(LIGHT_SOURCE_RADIUS.intValue(), LIGHT_SOURCE_RADIUS.intValue(), LIGHT_SOURCE_RADIUS.intValue())).filter(pos -> pos.m_123331_((Vec3i)zombiePosition) <= (double)(LIGHT_SOURCE_RADIUS * LIGHT_SOURCE_RADIUS)).forEach(pos -> {
            BlockState state = this.level.m_8055_(pos);
            if (state.m_60791_() != 0 && state.m_204336_(AFFECTED_BLOCKS)) {
                double distanceSquared = this.zombie.m_20238_(Vec3.m_82512_((Vec3i)pos));
                Path path = this.zombie.m_21573_().m_7864_(pos, 0);
                if (distanceSquared < (Double)closestDistance.get() && path != null && path.m_77403_()) {
                    closestDistance.set(distanceSquared);
                    foundPos.set(pos.m_7949_());
                    this.findingPath = path;
                }
            }
        });
        return (BlockPos)foundPos.get();
    }

    public boolean m_8045_() {
        return this.breakingCooldown <= 0 && this.targetLightPosition != null && this.level.m_8055_(this.targetLightPosition).m_60791_() != 0 && !(this.zombie.m_20238_(Vec3.m_82512_((Vec3i)this.targetLightPosition)) > (double)(LIGHT_SOURCE_RADIUS * LIGHT_SOURCE_RADIUS + 4));
    }

    public void m_8056_() {
        this.zombie.m_21573_().m_26536_(this.findingPath, 1.0);
        this.breakingTime = 0;
    }

    public void m_8041_() {
        this.targetLightPosition = null;
        this.breakingTime = 0;
        this.findingPath = null;
        this.zombie.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.targetLightPosition == null || this.findingPath == null) {
            return;
        }
        this.zombie.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.targetLightPosition));
        if (this.zombie.m_20238_(Vec3.m_82512_((Vec3i)this.targetLightPosition)) < 2.0) {
            ++this.breakingTime;
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
            if (this.breakingTime >= 100) {
                this.level.m_46953_(this.targetLightPosition, false, (Entity)this.zombie);
                this.breakingCooldown = 200;
                this.findingPath = null;
                this.targetLightPosition = null;
            }
        } else {
            this.zombie.m_21573_().m_26536_(this.findingPath, 1.0);
        }
    }
}

