/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.losthorizon.block;

import io.netty.buffer.Unpooled;
import net.mcreator.losthorizon.block.entity.RingInfuserBlockEntity;
import net.mcreator.losthorizon.world.inventory.RingInfuserGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RingInfuserBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public RingInfuserBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.NETHER_BRICKS).strength(10.0f, 6000.0f).lightLevel(s -> 5).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.join((VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)7.0, (double)28.0, (double)7.0, (double)16.0, (double)30.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)23.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)22.0, (double)6.0, (double)8.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)7.0, (double)10.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)8.0, (double)9.0, (double)23.0, (double)10.0), RingInfuserBlock.box((double)6.0, (double)22.0, (double)8.0, (double)8.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)18.0, (double)5.0, (double)8.0, (double)23.0, (double)6.0), RingInfuserBlock.box((double)8.0, (double)18.0, (double)10.0, (double)9.0, (double)23.0, (double)11.0), RingInfuserBlock.box((double)5.0, (double)18.0, (double)8.0, (double)6.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)10.0, (double)18.0, (double)7.0, (double)11.0, (double)23.0, (double)8.0)}), (VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)14.0, (double)5.0, (double)7.0, (double)16.0, (double)17.0, (double)9.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)22.5, (double)13.5, (double)7.0, (double)24.5, (double)21.5, (double)9.0), RingInfuserBlock.box((double)15.0, (double)28.5, (double)7.0, (double)27.0, (double)30.5, (double)9.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
            case Direction.NORTH -> Shapes.join((VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)0.0, (double)28.0, (double)7.0, (double)9.0, (double)30.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)23.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)8.0, (double)9.0, (double)23.0, (double)10.0), RingInfuserBlock.box((double)6.0, (double)22.0, (double)8.0, (double)8.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)22.0, (double)6.0, (double)8.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)7.0, (double)10.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)18.0, (double)10.0, (double)9.0, (double)23.0, (double)11.0), RingInfuserBlock.box((double)7.0, (double)18.0, (double)5.0, (double)8.0, (double)23.0, (double)6.0), RingInfuserBlock.box((double)10.0, (double)18.0, (double)7.0, (double)11.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)5.0, (double)18.0, (double)8.0, (double)6.0, (double)23.0, (double)9.0)}), (VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)0.0, (double)5.0, (double)7.0, (double)2.0, (double)17.0, (double)9.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)-8.5, (double)13.5, (double)7.0, (double)-6.5, (double)21.5, (double)9.0), RingInfuserBlock.box((double)-11.0, (double)28.5, (double)7.0, (double)1.0, (double)30.5, (double)9.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
            case Direction.EAST -> Shapes.join((VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)7.0, (double)28.0, (double)0.0, (double)9.0, (double)30.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)23.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0), RingInfuserBlock.box((double)6.0, (double)22.0, (double)8.0, (double)8.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)22.0, (double)6.0, (double)8.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)7.0, (double)10.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)8.0, (double)9.0, (double)23.0, (double)10.0), RingInfuserBlock.box((double)5.0, (double)18.0, (double)8.0, (double)6.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)10.0, (double)18.0, (double)7.0, (double)11.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)18.0, (double)10.0, (double)9.0, (double)23.0, (double)11.0), RingInfuserBlock.box((double)7.0, (double)18.0, (double)5.0, (double)8.0, (double)23.0, (double)6.0)}), (VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)17.0, (double)2.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)7.0, (double)13.5, (double)-8.5, (double)9.0, (double)21.5, (double)-6.5), RingInfuserBlock.box((double)7.0, (double)28.5, (double)-11.0, (double)9.0, (double)30.5, (double)1.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
            case Direction.WEST -> Shapes.join((VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)7.0, (double)28.0, (double)7.0, (double)9.0, (double)30.0, (double)16.0), RingInfuserBlock.box((double)7.0, (double)23.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)7.0, (double)10.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)8.0, (double)22.0, (double)8.0, (double)9.0, (double)23.0, (double)10.0), RingInfuserBlock.box((double)6.0, (double)22.0, (double)8.0, (double)8.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)22.0, (double)6.0, (double)8.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)10.0, (double)18.0, (double)7.0, (double)11.0, (double)23.0, (double)8.0), RingInfuserBlock.box((double)5.0, (double)18.0, (double)8.0, (double)6.0, (double)23.0, (double)9.0), RingInfuserBlock.box((double)7.0, (double)18.0, (double)5.0, (double)8.0, (double)23.0, (double)6.0), RingInfuserBlock.box((double)8.0, (double)18.0, (double)10.0, (double)9.0, (double)23.0, (double)11.0)}), (VoxelShape)Shapes.or((VoxelShape)RingInfuserBlock.box((double)7.0, (double)5.0, (double)14.0, (double)9.0, (double)17.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RingInfuserBlock.box((double)7.0, (double)13.5, (double)22.5, (double)9.0, (double)21.5, (double)24.5), RingInfuserBlock.box((double)7.0, (double)28.5, (double)15.0, (double)9.0, (double)30.5, (double)27.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Ring Infuser");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new RingInfuserGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RingInfuserBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof RingInfuserBlockEntity) {
            RingInfuserBlockEntity be = (RingInfuserBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

