/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.losthorizon.init;

import net.mcreator.losthorizon.entity.AshOfDawnProjectileEntity;
import net.mcreator.losthorizon.entity.BlackBlazeEntity;
import net.mcreator.losthorizon.entity.BlackBlazeEntityProjectile;
import net.mcreator.losthorizon.entity.CryptGuardianEntity;
import net.mcreator.losthorizon.entity.HeartGuardianEntity;
import net.mcreator.losthorizon.entity.LinkedEntity;
import net.mcreator.losthorizon.entity.NecromancerBossEntity;
import net.mcreator.losthorizon.entity.ThrowingKnifeEntity;
import net.mcreator.losthorizon.entity.ThrowingOnyxKnifeEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class LosthorizonModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"losthorizon");
    public static final DeferredHolder<EntityType<?>, EntityType<ThrowingKnifeEntity>> THROWING_KNIFE = LosthorizonModEntities.register("throwing_knife", EntityType.Builder.of(ThrowingKnifeEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrowingOnyxKnifeEntity>> THROWING_ONYX_KNIFE = LosthorizonModEntities.register("throwing_onyx_knife", EntityType.Builder.of(ThrowingOnyxKnifeEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<NecromancerBossEntity>> NECROMANCER = LosthorizonModEntities.register("necromancer", EntityType.Builder.of(NecromancerBossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CryptGuardianEntity>> CRYPT_GUARDIAN = LosthorizonModEntities.register("crypt_guardian", EntityType.Builder.of(CryptGuardianEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LinkedEntity>> LINKED = LosthorizonModEntities.register("linked", EntityType.Builder.of(LinkedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HeartGuardianEntity>> HEART_GUARDIAN = LosthorizonModEntities.register("heart_guardian", EntityType.Builder.of(HeartGuardianEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlackBlazeEntity>> BLACK_BLAZE = LosthorizonModEntities.register("black_blaze", EntityType.Builder.of(BlackBlazeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlackBlazeEntityProjectile>> BLACK_BLAZE_PROJECTILE = LosthorizonModEntities.register("projectile_black_blaze", EntityType.Builder.of(BlackBlazeEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<AshOfDawnProjectileEntity>> ASH_OF_DAWN_PROJECTILE = LosthorizonModEntities.register("ash_of_dawn_projectile", EntityType.Builder.of(AshOfDawnProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"losthorizon", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        NecromancerBossEntity.init(event);
        CryptGuardianEntity.init(event);
        LinkedEntity.init(event);
        HeartGuardianEntity.init(event);
        BlackBlazeEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)NECROMANCER.get(), NecromancerBossEntity.createAttributes().build());
        event.put((EntityType)CRYPT_GUARDIAN.get(), CryptGuardianEntity.createAttributes().build());
        event.put((EntityType)LINKED.get(), LinkedEntity.createAttributes().build());
        event.put((EntityType)HEART_GUARDIAN.get(), HeartGuardianEntity.createAttributes().build());
        event.put((EntityType)BLACK_BLAZE.get(), BlackBlazeEntity.createAttributes().build());
    }
}

