/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.losthorizon.init;

import java.util.Map;
import net.mcreator.losthorizon.init.LosthorizonModScreens;
import net.mcreator.losthorizon.network.MenuStateUpdateMessage;
import net.mcreator.losthorizon.world.inventory.BackPackExtendedGuiMenu;
import net.mcreator.losthorizon.world.inventory.BackPackGuiMenu;
import net.mcreator.losthorizon.world.inventory.RingInfuserGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class LosthorizonModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"losthorizon");
    public static final DeferredHolder<MenuType<?>, MenuType<BackPackGuiMenu>> BACK_PACK_GUI = REGISTRY.register("back_pack_gui", () -> IMenuTypeExtension.create(BackPackGuiMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<BackPackExtendedGuiMenu>> BACK_PACK_EXTENDED_GUI = REGISTRY.register("back_pack_extended_gui", () -> IMenuTypeExtension.create(BackPackExtendedGuiMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<RingInfuserGUIMenu>> RING_INFUSER_GUI = REGISTRY.register("ring_infuser_gui", () -> IMenuTypeExtension.create(RingInfuserGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof LosthorizonModScreens.ScreenAccessor) {
                    LosthorizonModScreens.ScreenAccessor accessor = (LosthorizonModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

