/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.losthorizon.network;

import java.util.function.Supplier;
import net.mcreator.losthorizon.LosthorizonMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class LosthorizonModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"losthorizon");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LosthorizonMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(LosthorizonModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(LosthorizonModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.homeX = original.homeX;
        clone.homeZ = original.homeZ;
        clone.homeY = original.homeY;
        if (!event.isWasDeath()) {
            clone.PreventClimbingFallDamage = original.PreventClimbingFallDamage;
            clone.nbrjump = original.nbrjump;
            clone.necromancer_grimoire = original.necromancer_grimoire;
            clone.ice_crystal_silver_ring_cooldown = original.ice_crystal_silver_ring_cooldown;
            clone.ice_crystal_gold_ring_cooldown = original.ice_crystal_gold_ring_cooldown;
            clone.onyx_gold_ring_cooldown = original.onyx_gold_ring_cooldown;
            clone.emerald_gold_ring_cooldown = original.emerald_gold_ring_cooldown;
            clone.starry_jade_iron_rinh_cooldown = original.starry_jade_iron_rinh_cooldown;
            clone.dice_cooldown = original.dice_cooldown;
            clone.linked_soul = original.linked_soul;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"losthorizon", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public boolean PreventClimbingFallDamage = false;
        public double homeX = 0.0;
        public double homeZ = 0.0;
        public double homeY = 0.0;
        public double nbrjump = 0.0;
        public boolean necromancer_grimoire = false;
        public boolean ice_crystal_silver_ring_cooldown = false;
        public boolean ice_crystal_gold_ring_cooldown = false;
        public boolean onyx_gold_ring_cooldown = false;
        public boolean emerald_gold_ring_cooldown = false;
        public boolean starry_jade_iron_rinh_cooldown = false;
        public boolean dice_cooldown = false;
        public double linked_soul = 0.0;

        public void serialize(ValueOutput output) {
            output.putBoolean("PreventClimbingFallDamage", this.PreventClimbingFallDamage);
            output.putDouble("homeX", this.homeX);
            output.putDouble("homeZ", this.homeZ);
            output.putDouble("homeY", this.homeY);
            output.putDouble("nbrjump", this.nbrjump);
            output.putBoolean("necromancer_grimoire", this.necromancer_grimoire);
            output.putBoolean("ice_crystal_silver_ring_cooldown", this.ice_crystal_silver_ring_cooldown);
            output.putBoolean("ice_crystal_gold_ring_cooldown", this.ice_crystal_gold_ring_cooldown);
            output.putBoolean("onyx_gold_ring_cooldown", this.onyx_gold_ring_cooldown);
            output.putBoolean("emerald_gold_ring_cooldown", this.emerald_gold_ring_cooldown);
            output.putBoolean("starry_jade_iron_rinh_cooldown", this.starry_jade_iron_rinh_cooldown);
            output.putBoolean("dice_cooldown", this.dice_cooldown);
            output.putDouble("linked_soul", this.linked_soul);
        }

        public void deserialize(ValueInput input) {
            this.PreventClimbingFallDamage = input.getBooleanOr("PreventClimbingFallDamage", false);
            this.homeX = input.getDoubleOr("homeX", 0.0);
            this.homeZ = input.getDoubleOr("homeZ", 0.0);
            this.homeY = input.getDoubleOr("homeY", 0.0);
            this.nbrjump = input.getDoubleOr("nbrjump", 0.0);
            this.necromancer_grimoire = input.getBooleanOr("necromancer_grimoire", false);
            this.ice_crystal_silver_ring_cooldown = input.getBooleanOr("ice_crystal_silver_ring_cooldown", false);
            this.ice_crystal_gold_ring_cooldown = input.getBooleanOr("ice_crystal_gold_ring_cooldown", false);
            this.onyx_gold_ring_cooldown = input.getBooleanOr("onyx_gold_ring_cooldown", false);
            this.emerald_gold_ring_cooldown = input.getBooleanOr("emerald_gold_ring_cooldown", false);
            this.starry_jade_iron_rinh_cooldown = input.getBooleanOr("starry_jade_iron_rinh_cooldown", false);
            this.dice_cooldown = input.getBooleanOr("dice_cooldown", false);
            this.linked_soul = input.getDoubleOr("linked_soul", 0.0);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }
}

