/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.losthorizon.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public class EnchantedForestFruitDecorator
extends CocoaDecorator {
    public static MapCodec<EnchantedForestFruitDecorator> CODEC = MapCodec.unit(EnchantedForestFruitDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"losthorizon:enchanted_forest_tree_fruit_decorator"), () -> DECORATOR_TYPE);
    }

    public EnchantedForestFruitDecorator() {
        super(0.2f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        ObjectArrayList list;
        RandomSource randomsource = context.random();
        if (!(randomsource.nextFloat() >= 0.2f) && !(list = context.logs()).isEmpty()) {
            int i = ((BlockPos)list.getFirst()).getY();
            list.stream().filter(p_69980_ -> p_69980_.getY() - i <= 2).forEach(p_226026_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(randomsource.nextFloat() <= 0.25f) || !context.isAir(blockpos = p_226026_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    context.setBlock(blockpos, (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(randomsource.nextInt(3)))).setValue((Property)CocoaBlock.FACING, (Comparable)direction));
                }
            });
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

