/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericItemHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class AutomationFilterItemHander
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final GenericItemHandler wrapped;

    public AutomationFilterItemHander(GenericItemHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.wrapped.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.wrapped.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.canAutomationInsert(slot)) {
            return stack;
        }
        return this.wrapped.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canAutomationExtract(slot)) {
            return ItemStack.EMPTY;
        }
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.wrapped.isItemValid(slot, stack);
    }

    public boolean canAutomationInsert(int slot) {
        return this.wrapped.getContainerFactory().isInputSlot(slot);
    }

    public boolean canAutomationExtract(int slot) {
        return this.wrapped.getContainerFactory().isOutputSlot(slot);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.wrapped.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.wrapped.deserializeNBT(provider, nbt);
    }
}

