/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.crafting;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public abstract class AbstractRecipeAdaptor
implements CraftingRecipe {
    private final ShapedRecipe recipe;

    public AbstractRecipeAdaptor(ShapedRecipe recipe) {
        this.recipe = recipe;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.recipe.canCraftInDimensions(width, height);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingInput inv) {
        return this.recipe.getRemainingItems((RecipeInput)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.recipe.getIngredients();
    }

    public boolean isSpecial() {
        return this.recipe.isSpecial();
    }

    @Nonnull
    public String getGroup() {
        return this.recipe.getGroup();
    }

    @Nonnull
    public ItemStack getToastSymbol() {
        return this.recipe.getToastSymbol();
    }

    public ShapedRecipe getRecipe() {
        return this.recipe;
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level worldIn) {
        return this.recipe.matches(inv, worldIn);
    }

    @Nonnull
    public RecipeType<?> getType() {
        return this.recipe.getType();
    }
}

