/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketRequestDataFromServer(ResourceKey<Level> level, BlockPos pos, String command, TypedMap params, boolean dummy) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mcjtylib", (String)"requestdatafromserver");
    public static final CustomPacketPayload.Type<PacketRequestDataFromServer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketRequestDataFromServer> CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PacketRequestDataFromServer::level, (StreamCodec)BlockPos.STREAM_CODEC, PacketRequestDataFromServer::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketRequestDataFromServer::command, TypedMap.STREAM_CODEC, PacketRequestDataFromServer::params, (StreamCodec)ByteBufCodecs.BOOL, PacketRequestDataFromServer::dummy, PacketRequestDataFromServer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketRequestDataFromServer create(ResourceKey<Level> type, BlockPos pos, String command, TypedMap params, boolean dummy) {
        return new PacketRequestDataFromServer(type, pos, command, params, dummy);
    }

    public static PacketRequestDataFromServer create(ResourceKey<Level> type, BlockPos pos, ICommand command, TypedMap params, boolean dummy) {
        return new PacketRequestDataFromServer(type, pos, command.name(), params, dummy);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ServerLevel world = LevelTools.getLevel(player.getCommandSenderWorld(), this.level);
            if (world.hasChunkAt(this.pos)) {
                GenericTileEntity generic;
                TypedMap result;
                BlockEntity patt0$temp = world.getBlockEntity(this.pos);
                if (patt0$temp instanceof GenericTileEntity && (result = (generic = (GenericTileEntity)patt0$temp).executeServerCommandWR(this.command, player, this.params)) != null) {
                    PacketDataFromServer msg = new PacketDataFromServer(this.dummy ? null : this.pos, this.command, result);
                    Networking.sendToPlayer(msg, player);
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
    }
}

