/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static RegistryAccess getRegistryAccess(Level level) {
        return level.registryAccess();
    }

    public static DeferredRegister<PlacementModifierType<?>> createPlacementRegistry(String modid) {
        return DeferredRegister.create((ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE, (String)modid);
    }

    public static void onDataPackRegistry(IEventBus bus, Consumer<IDPRegister> consumer) {
        bus.addListener(event -> consumer.accept(new IDPRegister((DataPackRegistryEvent.NewRegistry)event){
            final /* synthetic */ DataPackRegistryEvent.NewRegistry val$event;
            {
                this.val$event = newRegistry;
            }

            @Override
            public <T> void register(ResourceKey<Registry<T>> key, Codec<T> codec) {
                this.val$event.dataPackRegistry(key, codec, codec);
            }
        }));
    }

    public static Block getBlock(ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.get(id);
    }

    public static Item getItem(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.get(id);
    }

    public static EntityType<?> getEntity(ResourceLocation id) {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
    }

    public static Fluid getFluid(ResourceLocation id) {
        return (Fluid)BuiltInRegistries.FLUID.get(id);
    }

    public static MobEffect getEffect(ResourceLocation id) {
        return (MobEffect)BuiltInRegistries.MOB_EFFECT.get(id);
    }

    public static SoundEvent getSound(ResourceLocation resourceLocation) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(resourceLocation);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getId(ItemStack item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.getItem());
    }

    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getId(BlockState block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.getBlock());
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getId(FluidStack fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid());
    }

    public static ResourceLocation getId(FluidState fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid.getType());
    }

    public static ResourceLocation getId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static ResourceLocation getId(CommonLevelAccessor level, Biome biome) {
        return level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
    }

    public static ResourceLocation getId(CommonLevelAccessor level, Structure feature) {
        return level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)feature);
    }

    public static String getModid(ItemStack stack) {
        if (!stack.isEmpty()) {
            return Tools.getId(stack).getNamespace();
        }
        return "";
    }

    public static String getModName(Fluid entry) {
        ResourceLocation registryName = BuiltInRegistries.FLUID.getKey((Object)entry);
        String modId = registryName == null ? "minecraft" : registryName.getNamespace();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static String getModName(Block entry) {
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)entry);
        String modId = registryName == null ? "minecraft" : registryName.getNamespace();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer, String error) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static <INPUT extends BASE, BASE, RET> RET safeMap(BASE o, Function<INPUT, RET> consumer, String error) {
        try {
            return consumer.apply(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static String getReadableName(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return Tools.getReadableName(state.getBlock().getCloneItemStack((LevelReader)world, pos, state));
    }

    public static String getReadableName(ItemStack stack) {
        return stack.getHoverName().getString();
    }

    @Nullable
    public static BlockState placeStackAt(Player player, ItemStack blockStack, Level world, BlockPos pos, @Nullable BlockState origState) {
        BlockHitResult trace = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, trace));
        Item item = blockStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            if (origState == null && (origState = itemBlock.getBlock().getStateForPlacement(context)) == null) {
                return null;
            }
            if (itemBlock.place(context).consumesAction()) {
                blockStack.shrink(1);
            }
            return origState;
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, blockStack);
        player.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5);
        blockStack.getItem().useOn((UseOnContext)context);
        return world.getBlockState(pos);
    }

    public static interface IDPRegister {
        public <T> void register(ResourceKey<Registry<T>> var1, Codec<T> var2);
    }
}

