/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mcjty.lib.api.fluids.ItemFluids;
import mcjty.lib.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CustomTank
implements IFluidHandler,
IFluidTank {
    @Nonnull
    protected FluidStack fluid = FluidStack.EMPTY;
    protected int capacity;

    public CustomTank(int capacity) {
        this.capacity = capacity;
    }

    public CustomTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public void load(CompoundTag tag, String tagName, HolderLookup.Provider provider) {
        if (tag.contains(tagName)) {
            CompoundTag nbt = tag.getCompound(tagName);
            FluidStack fluid = FluidStack.parse((HolderLookup.Provider)provider, (Tag)nbt).orElse(FluidStack.EMPTY);
            this.setFluid(fluid);
        }
    }

    public void save(CompoundTag tag, String tagName, HolderLookup.Provider provider) {
        if (!this.fluid.isEmpty()) {
            CompoundTag nbt = new CompoundTag();
            this.fluid.save(provider, (Tag)nbt);
            tag.put(tagName, (Tag)nbt);
        }
    }

    public void applyImplicitComponents(ItemFluids itemFluids) {
        if (itemFluids != null && !itemFluids.fluids().isEmpty()) {
            this.fluid = itemFluids.fluids().get(0);
        }
    }

    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        fluidStacks.add(this.fluid);
        builder.set(Registration.ITEM_FLUIDS, (Object)new ItemFluids(fluidStacks));
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.onContentsChanged();
            this.fluid = new FluidStack(resource.getFluidHolder(), Math.min(this.capacity, resource.getAmount()), resource.getComponentsPatch());
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.onContentsChanged();
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.onContentsChanged();
            this.fluid.setAmount(this.capacity);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid.getFluidHolder(), drained, this.fluid.getComponentsPatch());
        if (action.execute()) {
            this.onContentsChanged();
            this.fluid.shrink(drained);
        }
        if (this.fluid.getAmount() <= 0) {
            this.fluid = FluidStack.EMPTY;
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public void setFluid(@Nonnull FluidStack stack) {
        this.fluid = stack;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluid.getAmount());
    }
}

