/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventoryTools {
    public static int getInventorySize(BlockEntity tileEntity) {
        if (tileEntity == null) {
            return 0;
        }
        IItemHandler handler = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntity.getBlockPos(), null);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public static boolean isInventory(BlockEntity te) {
        return te != null && te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null) != null;
    }

    public static Stream<ItemStack> getItems(BlockEntity tileEntity, Predicate<ItemStack> predicate) {
        IItemHandler handler;
        Stream.Builder<ItemStack> builder = Stream.builder();
        if (tileEntity != null && (handler = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntity.getBlockPos(), null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (itemStack.isEmpty() || !predicate.test(itemStack)) continue;
                builder.add(itemStack);
            }
        }
        return builder.build();
    }

    @Nonnull
    public static ItemStack getFirstMatchingItem(BlockEntity tileEntity, Predicate<ItemStack> predicate) {
        IItemHandler handler;
        if (tileEntity != null && (handler = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntity.getBlockPos(), null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (itemStack.isEmpty() || !predicate.test(itemStack)) continue;
                return itemStack;
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public static ItemStack insertItem(Level world, BlockPos pos, Direction direction, @Nonnull ItemStack s) {
        BlockEntity te = world.getBlockEntity(direction == null ? pos : pos.relative(direction));
        if (te != null) {
            Direction opposite = direction == null ? null : direction.getOpposite();
            IItemHandler handler = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), (Object)opposite);
            if (handler != null) {
                return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)s, (boolean)false);
            }
            return ItemStack.EMPTY;
        }
        return s;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return !itemstack1.isEmpty() && itemstack1.getItem() == result.getItem() && result.getDamageValue() == itemstack1.getDamageValue() && ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)itemstack1);
    }

    @Nonnull
    public static ItemStack insertItemRanged(IItemHandler dest, @Nonnull ItemStack stack, int start, int stop, boolean simulate) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = start; i < stop; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }
}

