/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;

public abstract class AbstractDynamicBakedModel
implements IDynamicBakedModel {
    public boolean usesBlockLight() {
        return false;
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resource) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(resource);
    }

    protected static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    protected BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        Vec3 normal = v3.subtract(v2).cross(v1.subtract(v2)).normalize();
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        builder.setSprite(sprite);
        builder.setDirection(Direction.getNearest((double)normal.x, (double)normal.y, (double)normal.z));
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v1.x, v1.y, v1.z, 0.0f, 0.0f, sprite, r, g, b, a);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v2.x, v2.y, v2.z, 0.0f, 1.0f, sprite, r, g, b, a);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v3.x, v3.y, v3.z, 1.0f, 1.0f, sprite, r, g, b, a);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v4.x, v4.y, v4.z, 1.0f, 0.0f, sprite, r, g, b, a);
        return builder.bakeQuad();
    }

    protected BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float hilight) {
        Vec3 normal = v3.subtract(v2).cross(v1.subtract(v2)).normalize();
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        builder.setSprite(sprite);
        builder.setDirection(Direction.getNearest((double)normal.x, (double)normal.y, (double)normal.z));
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v1.x, v1.y, v1.z, 0.0f, 0.0f, sprite, hilight, hilight, hilight, hilight);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v2.x, v2.y, v2.z, 0.0f, 1.0f, sprite, hilight, hilight, hilight, hilight);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v3.x, v3.y, v3.z, 1.0f, 1.0f, sprite, hilight, hilight, hilight, hilight);
        RenderHelper.putVertex((VertexConsumer)builder, (Position)normal, v4.x, v4.y, v4.z, 1.0f, 0.0f, sprite, hilight, hilight, hilight, hilight);
        return builder.bakeQuad();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

