/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.typed.Type;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

public class NamedCodec<T> {
    private final Codec<T> codec;
    private final T value;

    private NamedCodec(Codec<T> codec, T value) {
        this.codec = codec;
        this.value = value;
    }

    public static <T> NamedCodec<T> map(Codec<T> codec, T value) {
        return new NamedCodec<T>(codec, value);
    }

    public static <T> Object get(Codec<T> codec, T value, String name) {
        return NamedCodec.map(codec, value).get(name);
    }

    public Object get(String name) {
        DataResult result = this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.value);
        Tag tag = (Tag)result.getOrThrow();
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.scanTagForRead(tag, "", map);
        return map.get(name);
    }

    public T set(String name, Object v) {
        DataResult result = this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.value);
        Tag tag = (Tag)result.getOrThrow();
        this.scanTagForWrite((CompoundTag)tag, name, v);
        Pair resultOut = (Pair)this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
        return (T)resultOut.getFirst();
    }

    private byte convertToByte(Object v) {
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof Integer) {
            return ((Integer)v).byteValue();
        }
        if (v instanceof Long) {
            return ((Long)v).byteValue();
        }
        if (v instanceof Short) {
            return ((Short)v).byteValue();
        }
        if (v instanceof Float) {
            return ((Float)v).byteValue();
        }
        if (v instanceof Double) {
            return ((Double)v).byteValue();
        }
        if (v instanceof Boolean) {
            return (byte)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof String) {
            try {
                return Byte.parseByte((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to byte");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to byte");
    }

    private int convertToInt(Object v) {
        if (v instanceof Byte) {
            return ((Byte)v).byteValue();
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Long) {
            return ((Long)v).intValue();
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        if (v instanceof Float) {
            return (int)((Float)v).floatValue();
        }
        if (v instanceof Double) {
            return (int)((Double)v).doubleValue();
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to int");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to int");
    }

    private short convertToShort(Object v) {
        if (v instanceof Byte) {
            return ((Byte)v).byteValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).shortValue();
        }
        if (v instanceof Long) {
            return ((Long)v).shortValue();
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof Float) {
            return (short)((Float)v).floatValue();
        }
        if (v instanceof Double) {
            return (short)((Double)v).doubleValue();
        }
        if (v instanceof Boolean) {
            return (short)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof String) {
            try {
                return Short.parseShort((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to short");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to short");
    }

    private long convertToLong(Object v) {
        if (v instanceof Byte) {
            return ((Byte)v).byteValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).intValue();
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        if (v instanceof Float) {
            return (long)((Float)v).floatValue();
        }
        if (v instanceof Double) {
            return (long)((Double)v).doubleValue();
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1L : 0L;
        }
        if (v instanceof String) {
            try {
                return Long.parseLong((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to long");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to long");
    }

    private float convertToFloat(Object v) {
        if (v instanceof Byte) {
            return ((Byte)v).byteValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).intValue();
        }
        if (v instanceof Long) {
            return ((Long)v).longValue();
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        if (v instanceof Double) {
            return (float)((Double)v).doubleValue();
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1.0f : 0.0f;
        }
        if (v instanceof String) {
            try {
                return Float.parseFloat((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to float");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to float");
    }

    private double convertToDouble(Object v) {
        if (v instanceof Byte) {
            return ((Byte)v).byteValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).intValue();
        }
        if (v instanceof Long) {
            return ((Long)v).longValue();
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1.0 : 0.0;
        }
        if (v instanceof String) {
            try {
                return Double.parseDouble((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to double");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(v) + " to double");
    }

    public Type<?> getType(String attributeName) {
        DataResult result = this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.value);
        Tag tag = (Tag)result.getOrThrow();
        return this.scanTagForType((CompoundTag)tag, attributeName);
    }

    private Type<?> scanTagForType(CompoundTag tag, String key) {
        if (tag == null) {
            return Type.OBJECT;
        }
        if (tag.contains(key)) {
            Tag subTag = tag.get(key);
            switch (subTag.getId()) {
                case 8: {
                    return Type.STRING;
                }
                case 1: 
                case 2: 
                case 3: {
                    return Type.INTEGER;
                }
                case 4: {
                    return Type.LONG;
                }
                case 5: {
                    return Type.FLOAT;
                }
                case 6: {
                    return Type.DOUBLE;
                }
            }
        }
        for (String k : tag.getAllKeys()) {
            Tag subTag = tag.get(k);
            switch (subTag.getId()) {
                case 10: {
                    return this.scanTagForType((CompoundTag)subTag, key);
                }
            }
        }
        return Type.OBJECT;
    }

    private void scanTagForRead(Tag tag, String key, Map<String, Object> map) {
        if (tag == null) {
            return;
        }
        switch (tag.getId()) {
            case 10: {
                for (String k : ((CompoundTag)tag).getAllKeys()) {
                    this.scanTagForRead(((CompoundTag)tag).get(k), k, map);
                }
                break;
            }
            case 8: {
                map.put(key, tag.getAsString());
                break;
            }
            case 3: {
                map.put(key, ((IntTag)tag).getAsInt());
                break;
            }
            case 1: {
                map.put(key, ((ByteTag)tag).getAsByte());
                break;
            }
            case 2: {
                map.put(key, ((ShortTag)tag).getAsShort());
                break;
            }
            case 4: {
                map.put(key, ((LongTag)tag).getAsLong());
                break;
            }
            case 5: {
                map.put(key, Float.valueOf(((FloatTag)tag).getAsFloat()));
                break;
            }
            case 6: {
                map.put(key, ((DoubleTag)tag).getAsDouble());
            }
        }
    }

    private boolean scanTagForWrite(CompoundTag parent, String key, Object v) {
        if (parent.contains(key)) {
            Tag tag = parent.get(key);
            switch (tag.getId()) {
                case 8: {
                    parent.putString(key, v.toString());
                    return true;
                }
                case 3: {
                    parent.putInt(key, this.convertToInt(v));
                    return true;
                }
                case 1: {
                    parent.putByte(key, this.convertToByte(v));
                    return true;
                }
                case 2: {
                    parent.putShort(key, this.convertToShort(v));
                    return true;
                }
                case 4: {
                    parent.putLong(key, this.convertToLong(v));
                    return true;
                }
                case 5: {
                    parent.putFloat(key, this.convertToFloat(v));
                    return true;
                }
                case 6: {
                    parent.putDouble(key, this.convertToDouble(v));
                    return true;
                }
            }
        }
        for (String k : parent.getAllKeys()) {
            Tag tag = parent.get(k);
            switch (tag.getId()) {
                case 10: {
                    if (!this.scanTagForWrite((CompoundTag)tag, key, v)) break;
                    return true;
                }
            }
        }
        return false;
    }
}

