/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class OrientationTools {
    public static final Direction[] DIRECTION_VALUES = Direction.values();
    public static final Direction[] HORIZONTAL_DIRECTION_VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static Direction rotateAround(Direction input, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (input != Direction.WEST && input != Direction.EAST) {
                    return OrientationTools.rotateX(input);
                }
                return input;
            }
            case Y: {
                if (input != Direction.UP && input != Direction.DOWN) {
                    return input.getClockWise();
                }
                return input;
            }
            case Z: {
                if (input != Direction.NORTH && input != Direction.SOUTH) {
                    return OrientationTools.rotateZ(input);
                }
                return input;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + String.valueOf(axis));
    }

    private static Direction rotateX(Direction input) {
        return switch (input) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(input));
        };
    }

    private static Direction rotateZ(Direction input) {
        return switch (input) {
            default -> throw new MatchException(null, null);
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(input));
        };
    }

    public static Direction getOrientationHoriz(BlockState state) {
        return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public static Direction getOrientation(BlockState state) {
        return ((BaseBlock)state.getBlock()).getFrontDirection(state);
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return Direction.UP;
        }
        if (Mth.abs((float)((float)entityIn.getX() - (float)clickedBlock.getX())) < 2.0f && Mth.abs((float)((float)entityIn.getZ() - (float)clickedBlock.getZ())) < 2.0f) {
            double d0 = entityIn.getY() + (double)entityIn.getEyeHeight();
            if (d0 - (double)clickedBlock.getY() > 2.0) {
                return Direction.UP;
            }
            if ((double)clickedBlock.getY() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.getDirection().getOpposite();
    }
}

