/*
 * Decompiled with CFR 0.152.
 */
package com.james.breadplugin;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BreadPlugin
extends JavaPlugin
implements Listener {
    private final Set<UUID> recentlyDead = new HashSet<UUID>();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("BreadPlugin enabled. Bread awaits the fallen.");
    }

    public void onDisable() {
        this.getLogger().info("BreadPlugin disabled. The ovens cool.");
        this.recentlyDead.clear();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        this.recentlyDead.add(victim.getUniqueId());
        if (killer != null && killer != victim) {
            ItemStack bread = new ItemStack(Material.BREAD, 5);
            killer.getInventory().addItem(new ItemStack[]{bread});
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        UUID id = player.getUniqueId();
        if (this.recentlyDead.contains(id)) {
            ItemStack bread = new ItemStack(Material.BREAD, 5);
            player.getInventory().addItem(new ItemStack[]{bread});
            this.recentlyDead.remove(id);
        }
    }
}

