/*
 * Decompiled with CFR 0.152.
 */
package mc.mental.nicknamesEasyFolia;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import mc.mental.nicknamesEasyFolia.commands.Nick;
import mc.mental.nicknamesEasyFolia.commands.Realname;
import mc.mental.nicknamesEasyFolia.commands.Unnick;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NicknamesEasyFolia
extends JavaPlugin
implements Listener {
    private final ConcurrentMap<UUID, String> nicks = new ConcurrentHashMap<UUID, String>();
    private ExecutorService io;
    private File nickFile;
    private boolean allowColor;
    private int maxLen;
    private String allowedRegex;
    private Pattern allowedPattern;
    private boolean applyDisplay;
    private boolean applyTab;
    private boolean realnameLettersOnly;
    private static final LegacyComponentSerializer LEGACY_AMP = LegacyComponentSerializer.legacyAmpersand();
    private static final Pattern LEGACY_HEX = Pattern.compile("(?i)(?:&|\u00a7)x(?:[&\u00a7][0-9A-F]){6}");
    private static final Pattern LEGACY_SIMPLE = Pattern.compile("(?i)(?:&|\u00a7)[0-9A-FK-ORX]");
    private static final Pattern NON_LETTERS = Pattern.compile("[^\\p{L}\\p{M}]+");

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadMyConfig();
        this.io = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "NicknameEasy-IO");
            t.setDaemon(true);
            return t;
        });
        this.nickFile = new File(this.getDataFolder(), "nicks.yml");
        if (!this.nickFile.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.nickFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.loadNicksFromDisk();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Nick nickCmd = new Nick(this);
        this.getCommand("nick").setExecutor((CommandExecutor)nickCmd);
        this.getCommand("nick").setTabCompleter((TabCompleter)nickCmd);
        this.getCommand("unnick").setExecutor((CommandExecutor)new Unnick(this));
        this.getCommand("realname").setExecutor((CommandExecutor)new Realname(this));
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.scheduleOnPlayer(p, () -> this.applyNickIfAny(p));
        }
        this.getLogger().info("NicknameEasy (Folia) enabled.");
    }

    public void onDisable() {
        this.saveNicksNow();
        if (this.io != null) {
            this.io.shutdownNow();
        }
        this.getLogger().info("NicknameEasy (Folia) disabled.");
    }

    void reloadMyConfig() {
        this.reloadConfig();
        this.allowColor = this.getConfig().getBoolean("allowColorCodes", true);
        this.maxLen = Math.max(1, this.getConfig().getInt("maxLength", 16));
        this.allowedRegex = this.getConfig().getString("allowedChars", "^[\\p{L}\\p{M}\\p{Nd}_&\\-]+$");
        this.allowedPattern = Pattern.compile(this.allowedRegex);
        this.applyDisplay = this.getConfig().getBoolean("apply.displayName", true);
        this.applyTab = this.getConfig().getBoolean("apply.tabList", true);
        this.realnameLettersOnly = this.getConfig().getBoolean("realnameLettersOnly", true);
    }

    private void loadNicksFromDisk() {
        this.nicks.clear();
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.nickFile);
        if (cfg.isConfigurationSection("players")) {
            for (String key : Objects.requireNonNull(cfg.getConfigurationSection("players")).getKeys(false)) {
                try {
                    UUID id = UUID.fromString(key);
                    String val = cfg.getString("players." + key);
                    if (val == null || val.isEmpty()) continue;
                    this.nicks.put(id, val);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    void saveNicksAsync() {
        Map<UUID, String> snapshot = Map.copyOf(this.nicks);
        this.io.submit(() -> {
            YamlConfiguration out = new YamlConfiguration();
            for (Map.Entry e : snapshot.entrySet()) {
                out.set("players." + String.valueOf(e.getKey()), e.getValue());
            }
            try {
                out.save(this.nickFile);
            }
            catch (IOException ex) {
                this.getLogger().warning("Failed saving nicks.yml: " + ex.getMessage());
            }
        });
    }

    void saveNicksNow() {
        YamlConfiguration out = new YamlConfiguration();
        for (Map.Entry e : this.nicks.entrySet()) {
            out.set("players." + String.valueOf(e.getKey()), e.getValue());
        }
        try {
            out.save(this.nickFile);
        }
        catch (IOException ex) {
            this.getLogger().warning("Failed saving nicks.yml: " + ex.getMessage());
        }
    }

    public boolean setNick(Player p, String raw) {
        String clean = this.sanitize(raw);
        if (clean == null) {
            return false;
        }
        String stripped = NicknamesEasyFolia.stripLegacyCodes(clean);
        if (stripped.length() > this.maxLen) {
            return false;
        }
        this.nicks.put(p.getUniqueId(), clean);
        this.saveNicksAsync();
        this.applyNickIfAny(p);
        return true;
    }

    public void clearNick(UUID id) {
        this.nicks.remove(id);
        this.saveNicksAsync();
        Player p = Bukkit.getPlayer((UUID)id);
        if (p != null && p.isOnline()) {
            this.scheduleOnPlayer(p, () -> this.resetNick(p));
        }
    }

    public String getStoredNick(UUID id) {
        return (String)this.nicks.get(id);
    }

    public String findRealNameByNicknameQuery(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        String q = this.canonicalizeForLookup(input);
        for (Player player : Bukkit.getOnlinePlayers()) {
            String c;
            String raw = (String)this.nicks.get(player.getUniqueId());
            if (raw != null && (c = this.canonicalizeForLookup(raw)).equalsIgnoreCase(q)) {
                return player.getName();
            }
            if (!player.getName().equalsIgnoreCase(input)) continue;
            return player.getName();
        }
        for (Map.Entry entry : this.nicks.entrySet()) {
            String c = this.canonicalizeForLookup((String)entry.getValue());
            if (!c.equalsIgnoreCase(q)) continue;
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
            if (off != null && off.getName() != null) {
                return off.getName();
            }
            return null;
        }
        OfflinePlayer off = Bukkit.getOfflinePlayerIfCached((String)input);
        if (off != null && off.getName() != null) {
            return off.getName();
        }
        return null;
    }

    private String sanitize(String input) {
        if (input == null) {
            return null;
        }
        String s = input.trim();
        if (s.isEmpty()) {
            return null;
        }
        if (!this.allowedPattern.matcher(s).matches()) {
            return null;
        }
        if (!this.allowColor) {
            s = NicknamesEasyFolia.stripLegacyCodes(s);
        }
        return s;
    }

    public void scheduleOnPlayer(Player p, Runnable r) {
        p.getScheduler().execute((Plugin)this, r, null, 0L);
    }

    void applyNickIfAny(Player p) {
        TextComponent comp;
        String raw = (String)this.nicks.get(p.getUniqueId());
        if (raw == null) {
            this.resetNick(p);
            return;
        }
        TextComponent textComponent = comp = this.allowColor ? LEGACY_AMP.deserialize(raw) : Component.text((String)NicknamesEasyFolia.stripLegacyCodes(raw));
        if (this.applyDisplay) {
            p.displayName((Component)comp);
        }
        if (this.applyTab) {
            p.playerListName((Component)comp);
        }
    }

    void resetNick(Player p) {
        TextComponent name = Component.text((String)p.getName());
        if (this.applyDisplay) {
            p.displayName((Component)name);
        }
        if (this.applyTab) {
            p.playerListName((Component)name);
        }
    }

    public static String stripLegacyCodes(String s) {
        if (s == null) {
            return null;
        }
        s = LEGACY_HEX.matcher(s).replaceAll("");
        return LEGACY_SIMPLE.matcher(s).replaceAll("");
    }

    private String canonicalizeForLookup(String s) {
        String base = NicknamesEasyFolia.stripLegacyCodes(s);
        if (this.realnameLettersOnly) {
            base = NON_LETTERS.matcher(base).replaceAll("");
        }
        return base;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.scheduleOnPlayer(p, () -> this.applyNickIfAny(p));
    }
}

