/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractStorageDecorBlock;
import net.yirmiri.urban_decor.common.block.entity.StorageApplianceBlockEntity;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;

public class CupboardBlock
extends AbstractStorageDecorBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)3);
    private static final VoxelShape SHAPE_NORTH = Shapes.join((VoxelShape)Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH = Shapes.join((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST = Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)2.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_NORTH_BARE = Shapes.join((VoxelShape)Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)14.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_BARE = Shapes.join((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_BARE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_BARE = Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)4.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_NORTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_SOUTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_WEST = Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_EAST = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_NORTH_BARE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_SOUTH_BARE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_WEST_BARE = Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_FULL_EAST_BARE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public CupboardBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(2)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        boolean fullsize;
        int variant = (Integer)state.getValue((Property)VARIANT);
        boolean bl = fullsize = variant == 0 || variant == 1;
        if (fullsize) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> {
                    if (variant == 1) {
                        yield SHAPE_FULL_SOUTH_BARE;
                    }
                    yield SHAPE_FULL_SOUTH;
                }
                case Direction.WEST -> {
                    if (variant == 1) {
                        yield SHAPE_FULL_WEST_BARE;
                    }
                    yield SHAPE_FULL_WEST;
                }
                case Direction.EAST -> {
                    if (variant == 1) {
                        yield SHAPE_FULL_EAST_BARE;
                    }
                    yield SHAPE_FULL_EAST;
                }
                default -> variant == 1 ? SHAPE_FULL_NORTH_BARE : SHAPE_FULL_NORTH;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (variant == 3) {
                    yield SHAPE_SOUTH_BARE;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.WEST -> {
                if (variant == 3) {
                    yield SHAPE_WEST_BARE;
                }
                yield SHAPE_WEST;
            }
            case Direction.EAST -> {
                if (variant == 3) {
                    yield SHAPE_EAST_BARE;
                }
                yield SHAPE_EAST;
            }
            default -> variant == 3 ? SHAPE_NORTH_BARE : SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)VARIANT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.cupboard.variant_" + String.valueOf(state.getValue((Property)VARIANT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!player.getMainHandItem().getItem().getDefaultInstance().is(UDTags.ItemT.TOOLBOXES)) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof StorageApplianceBlockEntity) {
                player.openMenu((MenuProvider)((StorageApplianceBlockEntity)blockEntity));
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT, OPEN, TRUE_OPEN});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StorageApplianceBlockEntity(pos, state);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StorageApplianceBlockEntity) {
            ((StorageApplianceBlockEntity)blockEntity).recheckOpen();
        }
    }
}

