/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractStorageDecorBlock;
import net.yirmiri.urban_decor.common.block.entity.StorageApplianceBlockEntity;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;

public class FilingCabinetBlock
extends AbstractStorageDecorBlock {
    public static final BooleanProperty COMPACT = BooleanProperty.create((String)"compact");
    private static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FilingCabinetBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)COMPACT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)COMPACT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.filing_cabinet.variant_" + String.valueOf(state.getValue((Property)COMPACT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!player.getMainHandItem().getItem().getDefaultInstance().is(UDTags.ItemT.TOOLBOXES)) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof StorageApplianceBlockEntity && !player.isShiftKeyDown()) {
                player.openMenu((MenuProvider)((StorageApplianceBlockEntity)blockEntity));
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            }
            if (player.getMainHandItem().isEmpty() && player.isShiftKeyDown()) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.cycle((Property)OPEN)).cycle((Property)TRUE_OPEN));
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    this.playSound(level, pos, state, SoundEvents.IRON_DOOR_CLOSE);
                } else if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    this.playSound(level, pos, state, SoundEvents.IRON_DOOR_OPEN);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    void playSound(Level world, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.getValue((Property)AbstractStorageDecorBlock.FACING)).getNormal();
        double d = (double)pos.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)pos.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)pos.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        world.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN, COMPACT, TRUE_OPEN});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StorageApplianceBlockEntity(pos, state);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StorageApplianceBlockEntity) {
            ((StorageApplianceBlockEntity)blockEntity).recheckOpen();
        }
    }
}

