/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractFurnaceDecorBlock;
import net.yirmiri.urban_decor.core.init.UDTags;

public class MicrowaveBlock
extends AbstractFurnaceDecorBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)4.0, (double)0.0, (double)2.0, (double)11.0, (double)8.0, (double)14.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)5.0, (double)0.0, (double)2.0, (double)12.0, (double)8.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)8.0, (double)11.0);

    public MicrowaveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getMainHandItem().getItem().getDefaultInstance().is(UDTags.ItemT.TOOLBOXES)) {
            if (!level.isClientSide && !player.isShiftKeyDown()) {
                this.openContainer(level, pos, player);
                return InteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown()) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.cycle((Property)OPEN)).cycle((Property)TRUE_OPEN));
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                } else if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN, LIT, TRUE_OPEN});
    }
}

