/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractLongBlock;

public class PianoBlock
extends AbstractLongBlock {
    private static final VoxelShape BACK_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)12.0), Block.box((double)3.0, (double)10.0, (double)0.0, (double)11.0, (double)14.0, (double)12.0), Block.box((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape BACK_EAST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)8.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)4.0, (double)10.0, (double)3.0, (double)16.0, (double)14.0, (double)11.0), Block.box((double)4.0, (double)10.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape BACK_WEST = Stream.of(Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)8.0), Block.box((double)0.0, (double)10.0, (double)5.0, (double)12.0, (double)14.0, (double)13.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)12.0, (double)16.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape BACK_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)10.0, (double)16.0), Block.box((double)5.0, (double)10.0, (double)4.0, (double)13.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape FRONT_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)8.0, (double)0.0, (double)4.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)3.0, (double)10.0, (double)4.0, (double)11.0, (double)14.0, (double)16.0), Block.box((double)11.0, (double)10.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape FRONT_EAST = Stream.of(Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)12.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)3.0, (double)12.0, (double)14.0, (double)11.0), Block.box((double)0.0, (double)10.0, (double)11.0, (double)12.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape FRONT_WEST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0), Block.box((double)4.0, (double)10.0, (double)5.0, (double)16.0, (double)14.0, (double)13.0), Block.box((double)4.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape FRONT_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)10.0, (double)12.0), Block.box((double)5.0, (double)10.0, (double)0.0, (double)13.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)5.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PianoBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PART, (Comparable)BedPart.FOOT));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getHorizontalDirection().getOpposite().getClockWise(Direction.Axis.Y);
        BlockPos blockPos = ctx.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        Level world = ctx.getLevel();
        return world.getBlockState(blockPos2).canBeReplaced(ctx) && world.getWorldBorder().isWithinBounds(blockPos2) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        BedPart head = BedPart.HEAD;
        if (state.getValue((Property)PART) == head) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> FRONT_SOUTH;
                case Direction.WEST -> FRONT_WEST;
                case Direction.EAST -> FRONT_EAST;
                default -> FRONT_NORTH;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> BACK_SOUTH;
            case Direction.WEST -> BACK_WEST;
            case Direction.EAST -> BACK_EAST;
            default -> BACK_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, PART});
    }
}

