/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;

public class ShowerBlock
extends AbstractDecorBlock {
    public static final BooleanProperty ALT = BooleanProperty.create((String)"alt");
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    private static final VoxelShape SHAPE_NORTH = Shapes.join((VoxelShape)Block.box((double)7.0, (double)8.0, (double)8.0, (double)9.0, (double)10.0, (double)18.0), (VoxelShape)Block.box((double)5.0, (double)6.0, (double)6.0, (double)11.0, (double)8.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST = Shapes.join((VoxelShape)Block.box((double)8.0, (double)8.0, (double)7.0, (double)18.0, (double)10.0, (double)9.0), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)5.0, (double)12.0, (double)8.0, (double)11.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST = Shapes.join((VoxelShape)Block.box((double)-2.0, (double)8.0, (double)7.0, (double)8.0, (double)10.0, (double)9.0), (VoxelShape)Block.box((double)4.0, (double)6.0, (double)5.0, (double)10.0, (double)8.0, (double)11.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH = Shapes.join((VoxelShape)Block.box((double)7.0, (double)8.0, (double)-2.0, (double)9.0, (double)10.0, (double)8.0), (VoxelShape)Block.box((double)5.0, (double)6.0, (double)4.0, (double)11.0, (double)8.0, (double)10.0), (BooleanOp)BooleanOp.OR);

    public ShowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ALT, (Comparable)Boolean.valueOf(false))).setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)ALT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.shower.variant_" + String.valueOf(state.getValue((Property)ALT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (((Boolean)state.getValue((Property)ON)).booleanValue()) {
            UDUtils.spawnWaterParticles(1, world, pos, direction);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ALT, ON});
    }
}

