/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;

public class SinkBlock
extends AbstractDecorBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)3);
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    private static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)10.0, (double)16.0), Block.box((double)2.0, (double)10.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0), Block.box((double)13.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)14.0), Block.box((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)10.0, (double)14.0), Block.box((double)0.0, (double)10.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0), Block.box((double)4.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0), Block.box((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0), Block.box((double)4.0, (double)10.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)12.0), Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)10.0, (double)12.0), Block.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)13.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_NORTH_BARE = Stream.of(Block.box((double)2.0, (double)10.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0), Block.box((double)13.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST_BARE = Stream.of(Block.box((double)0.0, (double)10.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0), Block.box((double)4.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST_BARE = Stream.of(Block.box((double)4.0, (double)10.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH_BARE = Stream.of(Block.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)13.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_NORTH_CUPBOARD = Stream.of(Block.box((double)0.0, (double)10.0, (double)4.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)12.0), Block.box((double)13.0, (double)14.0, (double)3.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)2.0, (double)4.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH_CUPBOARD = Stream.of(Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)14.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)14.0, (double)4.0, (double)16.0, (double)16.0, (double)13.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0, (double)13.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)10.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)12.0), Block.box((double)2.0, (double)12.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST_CUPBOARD = Stream.of(Block.box((double)0.0, (double)10.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), Block.box((double)4.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)16.0), Block.box((double)12.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST_CUPBOARD = Stream.of(Block.box((double)4.0, (double)10.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), Block.box((double)3.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)3.0, (double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0), Block.box((double)4.0, (double)2.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_FULLSIZE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SinkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        boolean bare;
        int variant = (Integer)state.getValue((Property)VARIANT);
        boolean cupboard = variant == 2;
        boolean fullsize = variant == 3;
        boolean bl = bare = variant == 1;
        if (cupboard || fullsize) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> {
                    if (fullsize) {
                        yield SHAPE_FULLSIZE;
                    }
                    yield SHAPE_SOUTH_CUPBOARD;
                }
                case Direction.WEST -> {
                    if (fullsize) {
                        yield SHAPE_FULLSIZE;
                    }
                    yield SHAPE_WEST_CUPBOARD;
                }
                case Direction.EAST -> {
                    if (fullsize) {
                        yield SHAPE_FULLSIZE;
                    }
                    yield SHAPE_EAST_CUPBOARD;
                }
                default -> fullsize ? SHAPE_FULLSIZE : SHAPE_NORTH_CUPBOARD;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (bare) {
                    yield SHAPE_SOUTH_BARE;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.WEST -> {
                if (bare) {
                    yield SHAPE_WEST_BARE;
                }
                yield SHAPE_WEST;
            }
            case Direction.EAST -> {
                if (bare) {
                    yield SHAPE_EAST_BARE;
                }
                yield SHAPE_EAST;
            }
            default -> bare ? SHAPE_NORTH_BARE : SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)VARIANT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.sink.variant_" + String.valueOf(state.getValue((Property)VARIANT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (((Boolean)state.getValue((Property)ON)).booleanValue()) {
            UDUtils.spawnWaterParticles(1, world, pos, direction);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT, ON});
    }
}

