/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.entity.ToasterBlockEntity;
import net.yirmiri.urban_decor.core.init.UDDamageTypes;
import net.yirmiri.urban_decor.core.registry.UDBlockEntities;

public class ToasterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)3.0, (double)0.0, (double)7.0, (double)13.0, (double)6.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)4.0, (double)0.0, (double)3.0, (double)9.0, (double)6.0, (double)13.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)7.0, (double)0.0, (double)3.0, (double)12.0, (double)6.0, (double)13.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)6.0, (double)9.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<ToasterBlock> CODEC = ToasterBlock.simpleCodec(ToasterBlock::new);

    public ToasterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getMainHandItem().isEmpty()) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.8f, 1.0f, false);
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ToasterBlockEntity) {
                ToasterBlockEntity toasterBlockEntity = (ToasterBlockEntity)blockEntity;
                ItemStack itemStack = player.getItemInHand(hand);
                Optional<RecipeHolder<CampfireCookingRecipe>> optional = toasterBlockEntity.getCookableRecipe(itemStack);
                if (optional.isPresent() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.isClientSide && toasterBlockEntity.placeFood((LivingEntity)player, itemStack, ((CampfireCookingRecipe)optional.get().value()).getCookingTime())) {
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.getMainHandItem().isEmpty()) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.8f, 1.0f, false);
        }
        return InteractionResult.SUCCESS;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                entity.hurt(UDDamageTypes.of(entity.level(), UDDamageTypes.WET_TOASTER), 10.0f);
            }
            if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && !livingEntity.isSteppingCarefully()) {
                entity.hurt(UDDamageTypes.of(entity.level(), UDDamageTypes.TOASTER), 2.0f);
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof ToasterBlockEntity) {
                Containers.dropContents((Level)level, (BlockPos)pos, ((ToasterBlockEntity)blockentity).getItems());
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)LIT, (Comparable)Boolean.valueOf(!flag))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED, FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? ToasterBlock.createTickerHelper(blockEntityType, UDBlockEntities.TOASTER.get(), ToasterBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? ToasterBlock.createTickerHelper(blockEntityType, UDBlockEntities.TOASTER.get(), ToasterBlockEntity::cookTick) : ToasterBlock.createTickerHelper(blockEntityType, UDBlockEntities.TOASTER.get(), ToasterBlockEntity::cooldownTick);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

