/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;
import net.yirmiri.urban_decor.common.entity.ToiletEntity;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;
import net.yirmiri.urban_decor.core.registry.UDEntities;

public class ToiletBlock
extends AbstractDecorBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty ALT = BooleanProperty.create((String)"alt");
    private static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)5.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)2.0, (double)13.0, (double)7.0, (double)12.0), Block.box((double)3.0, (double)5.0, (double)12.0, (double)13.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)2.0, (double)0.0, (double)3.0, (double)11.0, (double)5.0, (double)13.0), Block.box((double)4.0, (double)5.0, (double)3.0, (double)14.0, (double)7.0, (double)13.0), Block.box((double)0.0, (double)5.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)5.0, (double)0.0, (double)3.0, (double)14.0, (double)5.0, (double)13.0), Block.box((double)2.0, (double)5.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0), Block.box((double)12.0, (double)5.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)5.0, (double)11.0), Block.box((double)3.0, (double)5.0, (double)4.0, (double)13.0, (double)7.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_NORTH_ALT = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)7.0, (double)10.0), Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)8.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST_ALT = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)14.0, (double)5.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)3.0, (double)10.0, (double)7.0, (double)13.0), Block.box((double)10.0, (double)5.0, (double)5.0, (double)14.0, (double)8.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST_ALT = Stream.of(Block.box((double)2.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.box((double)6.0, (double)5.0, (double)3.0, (double)16.0, (double)7.0, (double)13.0), Block.box((double)2.0, (double)5.0, (double)5.0, (double)6.0, (double)8.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH_ALT = Stream.of(Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)5.0, (double)11.0), Block.box((double)3.0, (double)5.0, (double)6.0, (double)13.0, (double)7.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)8.0, (double)6.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ToiletBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)ALT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        boolean alt = (Boolean)state.getValue((Property)ALT);
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (alt) {
                    yield SHAPE_SOUTH_ALT;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.WEST -> {
                if (alt) {
                    yield SHAPE_WEST_ALT;
                }
                yield SHAPE_WEST;
            }
            case Direction.EAST -> {
                if (alt) {
                    yield SHAPE_EAST_ALT;
                }
                yield SHAPE_EAST;
            }
            default -> alt ? SHAPE_NORTH_ALT : SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)ALT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.toilet.variant_" + String.valueOf(state.getValue((Property)ALT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getMainHandItem().getItem().getDefaultInstance().is(UDTags.ItemT.TOOLBOXES)) {
            if (player.isShiftKeyDown()) {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)OPEN));
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                } else if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHERRY_WOOD_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(player.isShiftKeyDown() || ((Boolean)state.getValue((Property)OCCUPIED)).booleanValue() || level.isClientSide)) {
                ToiletEntity toiletEntity = (ToiletEntity)UDEntities.TOILET.get().create(level);
                toiletEntity.setPosRaw((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)toiletEntity);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)));
                player.startRiding((Entity)toiletEntity);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN, ALT, OCCUPIED});
    }
}

