/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;
import net.yirmiri.urban_decor.common.util.UDUtils;
import net.yirmiri.urban_decor.core.init.UDTags;

public class ToiletPaperBlock
extends AbstractDecorBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)1);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)4.0, (double)6.0, (double)10.0, (double)12.0, (double)11.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)10.0, (double)6.0, (double)4.0, (double)15.0, (double)11.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)1.0, (double)6.0, (double)4.0, (double)6.0, (double)11.0, (double)12.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)4.0, (double)6.0, (double)1.0, (double)12.0, (double)11.0, (double)6.0);
    private static final VoxelShape SHAPE_COMMERCIAL_NORTH = Block.box((double)2.0, (double)4.0, (double)13.0, (double)14.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_COMMERCIAL_WEST = Block.box((double)13.0, (double)4.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    private static final VoxelShape SHAPE_COMMERCIAL_EAST = Block.box((double)0.0, (double)4.0, (double)2.0, (double)3.0, (double)12.0, (double)14.0);
    private static final VoxelShape SHAPE_COMMERCIAL_SOUTH = Block.box((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)12.0, (double)3.0);

    public ToiletPaperBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackHand = player.getItemInHand(hand);
        if (stackHand.is(UDTags.ItemT.TOOLBOXES)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)VARIANT));
            UDUtils.toolboxUsed(level, pos);
            player.displayClientMessage((Component)Component.translatable((String)("toolbox.toilet_paper.variant_" + String.valueOf(state.getValue((Property)VARIANT)))), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        int variant = (Integer)state.getValue((Property)VARIANT);
        boolean commercial = variant == 1;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (commercial) {
                    yield SHAPE_COMMERCIAL_SOUTH;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.WEST -> {
                if (commercial) {
                    yield SHAPE_COMMERCIAL_WEST;
                }
                yield SHAPE_WEST;
            }
            case Direction.EAST -> {
                if (commercial) {
                    yield SHAPE_COMMERCIAL_EAST;
                }
                yield SHAPE_EAST;
            }
            default -> commercial ? SHAPE_COMMERCIAL_NORTH : SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT});
    }
}

